/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.shape;

import androidx.annotation.FloatRange;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.unit.Density;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class PercentCornerSize
implements CornerSize {
    private final float percent;

    public PercentCornerSize(@FloatRange(from=0.0, to=100.0) float percent) {
        this.percent = percent;
        if (this.percent < 0.0f || this.percent > 100.0f) {
            InlineClassHelperKt.throwIllegalArgumentException("The percent should be in the range of [0, 100]");
        }
    }

    @Override
    public float toPx-TmRCtEA(long shapeSize, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return Size.getMinDimension-impl(shapeSize) * (this.percent / 100.0f);
    }

    @NotNull
    public String toString() {
        return "CornerSize(size = " + this.percent + "%)";
    }

    public int hashCode() {
        return Float.hashCode(this.percent);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PercentCornerSize)) {
            return false;
        }
        PercentCornerSize percentCornerSize = (PercentCornerSize)other;
        return Float.compare(this.percent, percentCornerSize.percent) == 0;
    }
}

