/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.collection.MutableObjectIntMap;
import androidx.collection.ObjectIntMap;
import androidx.collection.ObjectIntMapKt;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.layout.IntervalList;
import androidx.compose.foundation.lazy.layout.LazyLayoutIntervalContent;
import androidx.compose.foundation.lazy.layout.LazyLayoutKeyIndexMap;
import androidx.compose.foundation.lazy.layout.Lazy_desktopKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLazyLayoutKeyIndexMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyLayoutKeyIndexMap.kt\nandroidx/compose/foundation/lazy/layout/NearestRangeKeyIndexMap\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 ObjectIntMap.kt\nandroidx/collection/ObjectIntMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n51#2,4:97\n354#3,5:101\n1#4:106\n*S KotlinDebug\n*F\n+ 1 LazyLayoutKeyIndexMap.kt\nandroidx/compose/foundation/lazy/layout/NearestRangeKeyIndexMap\n*L\n62#1:97,4\n92#1:101,5\n*E\n"})
public final class NearestRangeKeyIndexMap
implements LazyLayoutKeyIndexMap {
    @NotNull
    private final ObjectIntMap<Object> map;
    @NotNull
    private final Object[] keys;
    private final int keysStartIndex;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public NearestRangeKeyIndexMap(@NotNull IntRange nearestRange, @NotNull LazyLayoutIntervalContent<?> intervalContent) {
        Intrinsics.checkNotNullParameter((Object)nearestRange, (String)"nearestRange");
        Intrinsics.checkNotNullParameter(intervalContent, (String)"intervalContent");
        IntervalList<?> list2 = intervalContent.getIntervals();
        int first = nearestRange.getFirst();
        boolean value$iv = first >= 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("negative nearestRange.first");
        }
        int last = Math.min(nearestRange.getLast(), list2.getSize() - 1);
        if (last < first) {
            this.map = ObjectIntMapKt.emptyObjectIntMap();
            this.keys = new Object[0];
            this.keysStartIndex = 0;
        } else {
            void map2;
            MutableObjectIntMap mutableObjectIntMap;
            int size = last - first + 1;
            this.keys = new Object[size];
            this.keysStartIndex = first;
            MutableObjectIntMap mutableObjectIntMap2 = mutableObjectIntMap = new MutableObjectIntMap(size);
            NearestRangeKeyIndexMap nearestRangeKeyIndexMap = this;
            boolean bl = false;
            list2.forEach(first, last, arg_0 -> NearestRangeKeyIndexMap.lambda$2$lambda$1(first, last, (MutableObjectIntMap)map2, this, arg_0));
            nearestRangeKeyIndexMap.map = (ObjectIntMap)mutableObjectIntMap;
        }
    }

    @Override
    public int getIndex(@NotNull Object key) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ObjectIntMap<Object> this_$iv = this.map;
        boolean $i$f$getOrElse = false;
        int index$iv = this_$iv.findKeyIndex(key);
        if (index$iv >= 0) {
            n = this_$iv.values[index$iv];
        } else {
            boolean bl = false;
            n = -1;
        }
        return n;
    }

    @Override
    @Nullable
    public Object getKey(int index) {
        Object object;
        Object[] objectArray = this.keys;
        int n = index - this.keysStartIndex;
        boolean bl = 0 <= n ? n < objectArray.length : false;
        if (bl) {
            object = objectArray[n];
        } else {
            int it = n;
            boolean bl2 = false;
            object = null;
        }
        return object;
    }

    private static final Unit lambda$2$lambda$1(int $first, int $last, MutableObjectIntMap $map, NearestRangeKeyIndexMap this$0, IntervalList.Interval it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Function1<Integer, Object> keyFactory = ((LazyLayoutIntervalContent.Interval)it.getValue()).getKey();
        int start2 = Math.max($first, it.getStartIndex());
        int end = Math.min($last, it.getStartIndex() + it.getSize() - 1);
        int i2 = start2;
        if (i2 <= end) {
            while (true) {
                Object object;
                if ((object = keyFactory) == null || (object = object.invoke((Object)(i2 - it.getStartIndex()))) == null) {
                    object = Lazy_desktopKt.getDefaultLazyLayoutKey(i2);
                }
                Object key = object;
                $map.set(key, i2);
                this$0.keys[i2 - this$0.keysStartIndex] = key;
                if (i2 == end) break;
                ++i2;
            }
        }
        return Unit.INSTANCE;
    }
}

