/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.LazyListItemProvider;
import androidx.compose.foundation.lazy.LazyListMeasureResult;
import androidx.compose.foundation.lazy.LazyListMeasuredItem;
import androidx.compose.foundation.lazy.layout.LazyLayoutItemProviderKt;
import androidx.compose.foundation.lazy.layout.LazyLayoutNearestRangeState;
import androidx.compose.runtime.IntState;
import androidx.compose.runtime.MutableIntState;
import androidx.compose.runtime.SnapshotIntStateKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLazyListScrollPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyListScrollPosition.kt\nandroidx/compose/foundation/lazy/LazyListScrollPosition\n+ 2 SnapshotIntState.kt\nandroidx/compose/runtime/SnapshotIntStateKt__SnapshotIntStateKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n*L\n1#1,123:1\n78#2:124\n107#2,2:125\n78#2:127\n107#2,2:128\n51#3,4:130\n51#3,4:134\n97#3,4:138\n*S KotlinDebug\n*F\n+ 1 LazyListScrollPosition.kt\nandroidx/compose/foundation/lazy/LazyListScrollPosition\n*L\n33#1:124\n33#1:125,2\n35#1:127\n35#1:128,2\n59#1:130,4\n67#1:134,4\n108#1:138,4\n*E\n"})
public final class LazyListScrollPosition {
    @NotNull
    private final MutableIntState index$delegate;
    @NotNull
    private final MutableIntState scrollOffset$delegate;
    private boolean hadFirstNotEmptyLayout;
    @Nullable
    private Object lastKnownFirstItemKey;
    @NotNull
    private final LazyLayoutNearestRangeState nearestRangeState;
    public static final int $stable = 8;

    public LazyListScrollPosition(int initialIndex, int initialScrollOffset) {
        this.index$delegate = SnapshotIntStateKt.mutableIntStateOf(initialIndex);
        this.scrollOffset$delegate = SnapshotIntStateKt.mutableIntStateOf(initialScrollOffset);
        this.nearestRangeState = new LazyLayoutNearestRangeState(initialIndex, 30, 100);
    }

    public /* synthetic */ LazyListScrollPosition(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getIndex() {
        void $this$getValue$iv;
        IntState intState = this.index$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setIndex(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.index$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    /*
     * WARNING - void declaration
     */
    public final int getScrollOffset() {
        void $this$getValue$iv;
        IntState intState = this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getIntValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setScrollOffset(int n) {
        void $this$setValue$iv;
        MutableIntState mutableIntState = this.scrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setIntValue(n);
    }

    @NotNull
    public final LazyLayoutNearestRangeState getNearestRangeState() {
        return this.nearestRangeState;
    }

    public final void updateFromMeasureResult(@NotNull LazyListMeasureResult measureResult) {
        Intrinsics.checkNotNullParameter((Object)measureResult, (String)"measureResult");
        LazyListMeasuredItem lazyListMeasuredItem = measureResult.getFirstVisibleItem();
        Object object = this.lastKnownFirstItemKey = lazyListMeasuredItem != null ? lazyListMeasuredItem.getKey() : null;
        if (this.hadFirstNotEmptyLayout || measureResult.getTotalItemsCount() > 0) {
            this.hadFirstNotEmptyLayout = true;
            int scrollOffset = measureResult.getFirstVisibleItemScrollOffset();
            boolean value$iv = (float)scrollOffset >= 0.0f;
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("scrollOffset should be non-negative");
            }
            LazyListMeasuredItem lazyListMeasuredItem2 = measureResult.getFirstVisibleItem();
            int firstIndex = lazyListMeasuredItem2 != null ? lazyListMeasuredItem2.getIndex() : 0;
            this.update(firstIndex, scrollOffset);
        }
    }

    public final void updateScrollOffset(int scrollOffset) {
        boolean value$iv = (float)scrollOffset >= 0.0f;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("scrollOffset should be non-negative");
        }
        this.setScrollOffset(scrollOffset);
    }

    public final void requestPositionAndForgetLastKnownKey(int index, int scrollOffset) {
        this.update(index, scrollOffset);
        this.lastKnownFirstItemKey = null;
    }

    public final int updateScrollPositionIfTheFirstItemWasMoved(@NotNull LazyListItemProvider itemProvider, int index) {
        Intrinsics.checkNotNullParameter((Object)itemProvider, (String)"itemProvider");
        int newIndex = LazyLayoutItemProviderKt.findIndexByKey(itemProvider, this.lastKnownFirstItemKey, index);
        if (index != newIndex) {
            this.setIndex(newIndex);
            this.nearestRangeState.update(index);
        }
        return newIndex;
    }

    private final void update(int index, int scrollOffset) {
        boolean value$iv = (float)index >= 0.0f;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Index should be non-negative (" + index + ")");
        }
        this.setIndex(index);
        this.nearestRangeState.update(index);
        this.setScrollOffset(scrollOffset);
    }

    public LazyListScrollPosition() {
        this(0, 0, 3, null);
    }
}

