/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListPrefetchScope;
import androidx.compose.foundation.lazy.LazyListPrefetchStrategy;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.lazy.layout.NestedPrefetchScope;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nLazyListPrefetchStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyListPrefetchStrategy.kt\nandroidx/compose/foundation/lazy/DefaultLazyListPrefetchStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1#2:201\n*E\n"})
final class DefaultLazyListPrefetchStrategy
implements LazyListPrefetchStrategy {
    private final int nestedPrefetchItemCount;
    private int indexToPrefetch;
    @Nullable
    private LazyLayoutPrefetchState.PrefetchHandle currentPrefetchHandle;
    private boolean wasScrollingForward;

    public DefaultLazyListPrefetchStrategy(int nestedPrefetchItemCount) {
        this.nestedPrefetchItemCount = nestedPrefetchItemCount;
        this.indexToPrefetch = -1;
    }

    public /* synthetic */ DefaultLazyListPrefetchStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    @Override
    public void onScroll(@NotNull LazyListPrefetchScope $this$onScroll, float delta, @NotNull LazyListLayoutInfo layoutInfo) {
        block5: {
            block6: {
                int indexToPrefetch;
                Intrinsics.checkNotNullParameter((Object)$this$onScroll, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
                if (!(!((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty())) break block5;
                boolean scrollingForward = delta < 0.0f;
                int n = indexToPrefetch = scrollingForward ? ((LazyListItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo())).getIndex() + 1 : ((LazyListItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo())).getIndex() - 1;
                boolean bl = 0 <= indexToPrefetch ? indexToPrefetch < layoutInfo.getTotalItemsCount() : false;
                if (!bl) break block5;
                if (indexToPrefetch != this.indexToPrefetch) {
                    if (this.wasScrollingForward != scrollingForward) {
                        LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                        if (prefetchHandle != null) {
                            prefetchHandle.cancel();
                        }
                    }
                    this.wasScrollingForward = scrollingForward;
                    this.indexToPrefetch = indexToPrefetch;
                    this.currentPrefetchHandle = $this$onScroll.schedulePrefetch(indexToPrefetch);
                }
                if (!scrollingForward) break block6;
                LazyListItemInfo lastItem = (LazyListItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo());
                int spacing = layoutInfo.getMainAxisItemSpacing();
                int distanceToPrefetchItem = lastItem.getOffset() + lastItem.getSize() + spacing - layoutInfo.getViewportEndOffset();
                if (!((float)distanceToPrefetchItem < -delta)) break block5;
                LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                if (prefetchHandle != null) {
                    prefetchHandle.markAsUrgent();
                }
                break block5;
            }
            LazyListItemInfo firstItem = (LazyListItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo());
            int distanceToPrefetchItem = layoutInfo.getViewportStartOffset() - firstItem.getOffset();
            if (!((float)distanceToPrefetchItem < delta)) break block5;
            LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
            if (prefetchHandle != null) {
                prefetchHandle.markAsUrgent();
            }
        }
    }

    @Override
    public void onVisibleItemsUpdated(@NotNull LazyListPrefetchScope $this$onVisibleItemsUpdated, @NotNull LazyListLayoutInfo layoutInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$onVisibleItemsUpdated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        if (this.indexToPrefetch != -1 && !((Collection)layoutInfo.getVisibleItemsInfo()).isEmpty()) {
            int expectedPrefetchIndex;
            int n = expectedPrefetchIndex = this.wasScrollingForward ? ((LazyListItemInfo)CollectionsKt.last(layoutInfo.getVisibleItemsInfo())).getIndex() + 1 : ((LazyListItemInfo)CollectionsKt.first(layoutInfo.getVisibleItemsInfo())).getIndex() - 1;
            if (this.indexToPrefetch != expectedPrefetchIndex) {
                this.indexToPrefetch = -1;
                LazyLayoutPrefetchState.PrefetchHandle prefetchHandle = this.currentPrefetchHandle;
                if (prefetchHandle != null) {
                    prefetchHandle.cancel();
                }
                this.currentPrefetchHandle = null;
            }
        }
    }

    @Override
    public void onNestedPrefetch(@NotNull NestedPrefetchScope $this$onNestedPrefetch, int firstVisibleItemIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$onNestedPrefetch, (String)"<this>");
        int n = this.nestedPrefetchItemCount;
        int n2 = 0;
        while (n2 < n) {
            int i2 = n2++;
            boolean bl = false;
            $this$onNestedPrefetch.schedulePrefetch(firstVisibleItemIndex + i2);
        }
    }

    public DefaultLazyListPrefetchStrategy() {
        this(0, 1, null);
    }
}

