/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.CrossAxisAlignment;
import androidx.compose.foundation.layout.RowColumnImplKt;
import androidx.compose.foundation.layout.RowColumnMeasurePolicy;
import androidx.compose.foundation.layout.RowColumnParentData;
import androidx.compose.foundation.layout.RowKt;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface FlowLineMeasurePolicy
extends RowColumnMeasurePolicy {
    public boolean isHorizontal();

    @NotNull
    public Arrangement.Horizontal getHorizontalArrangement();

    @NotNull
    public Arrangement.Vertical getVerticalArrangement();

    @NotNull
    public CrossAxisAlignment getCrossAxisAlignment();

    @Override
    default public int mainAxisSize(@NotNull Placeable $this$mainAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$mainAxisSize, (String)"<this>");
        return this.isHorizontal() ? $this$mainAxisSize.getMeasuredWidth() : $this$mainAxisSize.getMeasuredHeight();
    }

    @Override
    default public int crossAxisSize(@NotNull Placeable $this$crossAxisSize) {
        Intrinsics.checkNotNullParameter((Object)$this$crossAxisSize, (String)"<this>");
        return this.isHorizontal() ? $this$crossAxisSize.getMeasuredHeight() : $this$crossAxisSize.getMeasuredWidth();
    }

    @Override
    default public long createConstraints-xF2OJ5Q(int mainAxisMin, int crossAxisMin, int mainAxisMax, int crossAxisMax, boolean isPrioritizing) {
        return this.isHorizontal() ? RowKt.createRowConstraints(isPrioritizing, mainAxisMin, crossAxisMin, mainAxisMax, crossAxisMax) : ColumnKt.createColumnConstraints(isPrioritizing, mainAxisMin, crossAxisMin, mainAxisMax, crossAxisMax);
    }

    @Override
    @NotNull
    default public MeasureResult placeHelper(@NotNull Placeable[] placeables, @NotNull MeasureScope measureScope, int beforeCrossAxisAlignmentLine, @NotNull int[] mainAxisPositions, int mainAxisLayoutSize, int crossAxisLayoutSize, @Nullable int[] crossAxisOffset, int currentLineIndex, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)placeables, (String)"placeables");
        Intrinsics.checkNotNullParameter((Object)measureScope, (String)"measureScope");
        Intrinsics.checkNotNullParameter((Object)mainAxisPositions, (String)"mainAxisPositions");
        MeasureScope $this$placeHelper_u24lambda_u241 = measureScope;
        boolean bl = false;
        int width = 0;
        int height = 0;
        if (this.isHorizontal()) {
            width = mainAxisLayoutSize;
            height = crossAxisLayoutSize;
        } else {
            width = crossAxisLayoutSize;
            height = mainAxisLayoutSize;
        }
        LayoutDirection layoutDirection = this.isHorizontal() ? LayoutDirection.Ltr : $this$placeHelper_u24lambda_u241.getLayoutDirection();
        return MeasureScope.layout$default($this$placeHelper_u24lambda_u241, width, height, null, arg_0 -> FlowLineMeasurePolicy.placeHelper$lambda$1$lambda$0(crossAxisOffset, currentLineIndex, startIndex, endIndex, placeables, this, crossAxisLayoutSize, layoutDirection, beforeCrossAxisAlignmentLine, mainAxisPositions, arg_0), 4, null);
    }

    default public int getCrossAxisPosition(@NotNull Placeable placeable, int crossAxisLayoutSize, @NotNull LayoutDirection layoutDirection, int beforeCrossAxisAlignmentLine) {
        Intrinsics.checkNotNullParameter((Object)placeable, (String)"placeable");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        Object object = RowColumnImplKt.getRowColumnParentData(placeable);
        if (object == null || (object = ((RowColumnParentData)object).getCrossAxisAlignment()) == null) {
            object = this.getCrossAxisAlignment();
        }
        Object childCrossAlignment = object;
        return ((CrossAxisAlignment)childCrossAlignment).align$foundation_layout(crossAxisLayoutSize - this.crossAxisSize(placeable), layoutDirection, placeable, beforeCrossAxisAlignmentLine);
    }

    @Override
    default public void populateMainAxisPositions(int mainAxisLayoutSize, @NotNull int[] childrenMainAxisSize, @NotNull int[] mainAxisPositions, @NotNull MeasureScope measureScope) {
        Intrinsics.checkNotNullParameter((Object)childrenMainAxisSize, (String)"childrenMainAxisSize");
        Intrinsics.checkNotNullParameter((Object)mainAxisPositions, (String)"mainAxisPositions");
        Intrinsics.checkNotNullParameter((Object)measureScope, (String)"measureScope");
        if (this.isHorizontal()) {
            Arrangement.Horizontal $this$populateMainAxisPositions_u24lambda_u242 = this.getHorizontalArrangement();
            boolean bl = false;
            $this$populateMainAxisPositions_u24lambda_u242.arrange(measureScope, mainAxisLayoutSize, childrenMainAxisSize, measureScope.getLayoutDirection(), mainAxisPositions);
        } else {
            Arrangement.Vertical $this$populateMainAxisPositions_u24lambda_u243 = this.getVerticalArrangement();
            boolean bl = false;
            $this$populateMainAxisPositions_u24lambda_u243.arrange(measureScope, mainAxisLayoutSize, childrenMainAxisSize, mainAxisPositions);
        }
    }

    private static Unit placeHelper$lambda$1$lambda$0(int[] $crossAxisOffset, int $currentLineIndex, int $startIndex, int $endIndex, Placeable[] $placeables, FlowLineMeasurePolicy this$0, int $crossAxisLayoutSize, LayoutDirection $layoutDirection, int $beforeCrossAxisAlignmentLine, int[] $mainAxisPositions, Placeable.PlacementScope $this$layout) {
        Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
        int crossAxisLineOffset = $crossAxisOffset != null ? $crossAxisOffset[$currentLineIndex] : 0;
        for (int i2 = $startIndex; i2 < $endIndex; ++i2) {
            Placeable placeable;
            Intrinsics.checkNotNull((Object)$placeables[i2]);
            int crossAxisPosition = this$0.getCrossAxisPosition(placeable, $crossAxisLayoutSize, $layoutDirection, $beforeCrossAxisAlignmentLine) + crossAxisLineOffset;
            if (this$0.isHorizontal()) {
                Placeable.PlacementScope.place$default($this$layout, placeable, $mainAxisPositions[i2 - $startIndex], crossAxisPosition, 0.0f, 4, null);
                continue;
            }
            Placeable.PlacementScope.place$default($this$layout, placeable, crossAxisPosition, $mainAxisPositions[i2 - $startIndex], 0.0f, 4, null);
        }
        return Unit.INSTANCE;
    }
}

