/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.WindowInsets;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FixedIntInsets
implements WindowInsets {
    private final int leftVal;
    private final int topVal;
    private final int rightVal;
    private final int bottomVal;

    public FixedIntInsets(int leftVal, int topVal, int rightVal, int bottomVal) {
        this.leftVal = leftVal;
        this.topVal = topVal;
        this.rightVal = rightVal;
        this.bottomVal = bottomVal;
    }

    @Override
    public int getLeft(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return this.leftVal;
    }

    @Override
    public int getTop(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return this.topVal;
    }

    @Override
    public int getRight(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return this.rightVal;
    }

    @Override
    public int getBottom(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return this.bottomVal;
    }

    @NotNull
    public String toString() {
        return "Insets(left=" + this.leftVal + ", top=" + this.topVal + ", right=" + this.rightVal + ", bottom=" + this.bottomVal + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FixedIntInsets)) {
            return false;
        }
        return this.leftVal == ((FixedIntInsets)other).leftVal && this.topVal == ((FixedIntInsets)other).topVal && this.rightVal == ((FixedIntInsets)other).rightVal && this.bottomVal == ((FixedIntInsets)other).bottomVal;
    }

    public int hashCode() {
        int result2 = this.leftVal;
        result2 = 31 * result2 + this.topVal;
        result2 = 31 * result2 + this.rightVal;
        result2 = 31 * result2 + this.bottomVal;
        return result2;
    }
}

