/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.Direction;
import androidx.compose.foundation.layout.FillNode;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FillElement
extends ModifierNodeElement<FillNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Direction direction;
    private final float fraction;
    @NotNull
    private final String inspectorName;

    public FillElement(@NotNull Direction direction, float fraction, @NotNull String inspectorName) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)inspectorName, (String)"inspectorName");
        this.direction = direction;
        this.fraction = fraction;
        this.inspectorName = inspectorName;
    }

    @Override
    @NotNull
    public FillNode create() {
        return new FillNode(this.direction, this.fraction);
    }

    @Override
    public void update(@NotNull FillNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setDirection(this.direction);
        node2.setFraction(this.fraction);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FillElement)) {
            return false;
        }
        if (this.direction != ((FillElement)other).direction) {
            return false;
        }
        return this.fraction == ((FillElement)other).fraction;
    }

    public int hashCode() {
        int result2 = this.direction.hashCode();
        result2 = 31 * result2 + Float.hashCode(this.fraction);
        return result2;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FillElement width(float fraction) {
            return new FillElement(Direction.Horizontal, fraction, "fillMaxWidth");
        }

        @NotNull
        public final FillElement height(float fraction) {
            return new FillElement(Direction.Vertical, fraction, "fillMaxHeight");
        }

        @NotNull
        public final FillElement size(float fraction) {
            return new FillElement(Direction.Both, fraction, "fillMaxSize");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

