/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.WindowInsets;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExcludeInsets
implements WindowInsets {
    @NotNull
    private final WindowInsets included;
    @NotNull
    private final WindowInsets excluded;

    public ExcludeInsets(@NotNull WindowInsets included, @NotNull WindowInsets excluded) {
        Intrinsics.checkNotNullParameter((Object)included, (String)"included");
        Intrinsics.checkNotNullParameter((Object)excluded, (String)"excluded");
        this.included = included;
        this.excluded = excluded;
    }

    @Override
    public int getLeft(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return RangesKt.coerceAtLeast((int)(this.included.getLeft(density, layoutDirection) - this.excluded.getLeft(density, layoutDirection)), (int)0);
    }

    @Override
    public int getTop(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return RangesKt.coerceAtLeast((int)(this.included.getTop(density) - this.excluded.getTop(density)), (int)0);
    }

    @Override
    public int getRight(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return RangesKt.coerceAtLeast((int)(this.included.getRight(density, layoutDirection) - this.excluded.getRight(density, layoutDirection)), (int)0);
    }

    @Override
    public int getBottom(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return RangesKt.coerceAtLeast((int)(this.included.getBottom(density) - this.excluded.getBottom(density)), (int)0);
    }

    @NotNull
    public String toString() {
        return "(" + this.included + " - " + this.excluded + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExcludeInsets)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((ExcludeInsets)other).included, (Object)this.included) && Intrinsics.areEqual((Object)((ExcludeInsets)other).excluded, (Object)this.excluded);
    }

    public int hashCode() {
        return 31 * this.included.hashCode() + this.excluded.hashCode();
    }
}

