/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.BoxChildDataNode;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BoxChildDataElement
extends ModifierNodeElement<BoxChildDataNode> {
    @NotNull
    private final Alignment alignment;
    private final boolean matchParentSize;
    @NotNull
    private final Function1<InspectorInfo, Unit> inspectorInfo;

    public BoxChildDataElement(@NotNull Alignment alignment, boolean matchParentSize, @NotNull Function1<? super InspectorInfo, Unit> inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        Intrinsics.checkNotNullParameter(inspectorInfo, (String)"inspectorInfo");
        this.alignment = alignment;
        this.matchParentSize = matchParentSize;
        this.inspectorInfo = inspectorInfo;
    }

    @Override
    @NotNull
    public BoxChildDataNode create() {
        return new BoxChildDataNode(this.alignment, this.matchParentSize);
    }

    @Override
    public void update(@NotNull BoxChildDataNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setAlignment(this.alignment);
        node2.setMatchParentSize(this.matchParentSize);
    }

    public int hashCode() {
        int result2 = this.alignment.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.matchParentSize);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        BoxChildDataElement boxChildDataElement = other instanceof BoxChildDataElement ? (BoxChildDataElement)other : null;
        if (boxChildDataElement == null) {
            return false;
        }
        BoxChildDataElement otherModifier = boxChildDataElement;
        return Intrinsics.areEqual((Object)this.alignment, (Object)otherModifier.alignment) && this.matchParentSize == otherModifier.matchParentSize;
    }
}

