/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.OverscrollEffect;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollableNode;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScrollableElement
extends ModifierNodeElement<ScrollableNode> {
    @NotNull
    private final ScrollableState state;
    @NotNull
    private final Orientation orientation;
    @Nullable
    private final OverscrollEffect overscrollEffect;
    private final boolean enabled;
    private final boolean reverseDirection;
    @Nullable
    private final FlingBehavior flingBehavior;
    @Nullable
    private final MutableInteractionSource interactionSource;
    @Nullable
    private final BringIntoViewSpec bringIntoViewSpec;

    public ScrollableElement(@NotNull ScrollableState state2, @NotNull Orientation orientation, @Nullable OverscrollEffect overscrollEffect, boolean enabled, boolean reverseDirection, @Nullable FlingBehavior flingBehavior, @Nullable MutableInteractionSource interactionSource, @Nullable BringIntoViewSpec bringIntoViewSpec) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.state = state2;
        this.orientation = orientation;
        this.overscrollEffect = overscrollEffect;
        this.enabled = enabled;
        this.reverseDirection = reverseDirection;
        this.flingBehavior = flingBehavior;
        this.interactionSource = interactionSource;
        this.bringIntoViewSpec = bringIntoViewSpec;
    }

    @Override
    @NotNull
    public ScrollableNode create() {
        return new ScrollableNode(this.state, this.overscrollEffect, this.flingBehavior, this.orientation, this.enabled, this.reverseDirection, this.interactionSource, this.bringIntoViewSpec);
    }

    @Override
    public void update(@NotNull ScrollableNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.update(this.state, this.orientation, this.overscrollEffect, this.enabled, this.reverseDirection, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
    }

    public int hashCode() {
        int result2 = this.state.hashCode();
        result2 = 31 * result2 + this.orientation.hashCode();
        OverscrollEffect overscrollEffect = this.overscrollEffect;
        result2 = 31 * result2 + (overscrollEffect != null ? overscrollEffect.hashCode() : 0);
        result2 = 31 * result2 + Boolean.hashCode(this.enabled);
        result2 = 31 * result2 + Boolean.hashCode(this.reverseDirection);
        FlingBehavior flingBehavior = this.flingBehavior;
        result2 = 31 * result2 + (flingBehavior != null ? flingBehavior.hashCode() : 0);
        MutableInteractionSource mutableInteractionSource = this.interactionSource;
        result2 = 31 * result2 + (mutableInteractionSource != null ? mutableInteractionSource.hashCode() : 0);
        BringIntoViewSpec bringIntoViewSpec = this.bringIntoViewSpec;
        result2 = 31 * result2 + (bringIntoViewSpec != null ? bringIntoViewSpec.hashCode() : 0);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScrollableElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)((ScrollableElement)other).state)) {
            return false;
        }
        if (this.orientation != ((ScrollableElement)other).orientation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.overscrollEffect, (Object)((ScrollableElement)other).overscrollEffect)) {
            return false;
        }
        if (this.enabled != ((ScrollableElement)other).enabled) {
            return false;
        }
        if (this.reverseDirection != ((ScrollableElement)other).reverseDirection) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.flingBehavior, (Object)((ScrollableElement)other).flingBehavior)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.interactionSource, (Object)((ScrollableElement)other).interactionSource)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bringIntoViewSpec, (Object)((ScrollableElement)other).bringIntoViewSpec);
    }
}

