/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.FloatRange;
import androidx.collection.MutableObjectList;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.animation.core.Transition;
import androidx.compose.animation.core.TransitionKt;
import androidx.compose.animation.core.TransitionState;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.State;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.sync.Mutex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/SeekableTransitionState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n+ 5 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n+ 6 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 7 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 8 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,2141:1\n85#2:2142\n113#2,2:2143\n85#2:2145\n113#2,2:2146\n79#3:2148\n112#3,2:2149\n71#4:2151\n34#5,4:2152\n53#5,4:2180\n310#6,11:2156\n310#6,11:2167\n919#7,2:2178\n943#7,4:2190\n947#7,8:2195\n287#8,6:2184\n84#8:2194\n*S KotlinDebug\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/SeekableTransitionState\n*L\n218#1:2142\n218#1:2143,2\n221#1:2145\n221#1:2146,2\n250#1:2148\n250#1:2149,2\n413#1:2151\n482#1:2152,4\n679#1:2180,4\n523#1:2156,11\n544#1:2167,11\n573#1:2178,2\n307#1:2190,4\n307#1:2195,8\n300#1:2184,6\n307#1:2194\n*E\n"})
public final class SeekableTransitionState<S>
extends TransitionState<S> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableState targetState$delegate;
    @NotNull
    private final MutableState currentState$delegate;
    private S composedTargetState;
    @Nullable
    private Transition<S> transition;
    private long totalDurationNanos;
    @NotNull
    private final Function0<Unit> recalculateTotalDurationNanos;
    @NotNull
    private final MutableFloatState fraction$delegate;
    @Nullable
    private CancellableContinuation<? super S> compositionContinuation;
    @NotNull
    private final Mutex compositionContinuationMutex;
    @NotNull
    private final MutableObjectList<SeekingAnimationState> initialValueAnimations;
    @Nullable
    private SeekingAnimationState currentAnimation;
    public static final int $stable = 8;
    @NotNull
    private static final AnimationVector1D ZeroVelocity = new AnimationVector1D(0.0f);
    @NotNull
    private static final AnimationVector1D Target1 = new AnimationVector1D(1.0f);

    /*
     * WARNING - void declaration
     */
    @Override
    public S getTargetState() {
        void $this$getValue$iv;
        State state2 = this.targetState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (S)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public S getCurrentState() {
        void $this$getValue$iv;
        State state2 = this.currentState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (S)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCurrentState$animation_core(S s) {
        void $this$setValue$iv;
        MutableState mutableState = this.currentState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(s);
    }

    public final void setComposedTargetState$animation_core(S s) {
        this.composedTargetState = s;
    }

    /*
     * WARNING - void declaration
     */
    @FloatRange(from=0.0, to=1.0)
    public final float getFraction() {
        void $this$getValue$iv;
        FloatState floatState = this.fraction$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setFraction(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.fraction$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    @Nullable
    public final CancellableContinuation<S> getCompositionContinuation$animation_core() {
        return this.compositionContinuation;
    }

    public final void setCompositionContinuation$animation_core(@Nullable CancellableContinuation<? super S> cancellableContinuation) {
        this.compositionContinuation = cancellableContinuation;
    }

    @NotNull
    public final Mutex getCompositionContinuationMutex$animation_core() {
        return this.compositionContinuationMutex;
    }

    private final void endAllAnimations() {
        Transition<S> transition = this.transition;
        if (transition != null) {
            transition.clearInitialAnimations$animation_core();
        }
        this.initialValueAnimations.clear();
        SeekingAnimationState current = this.currentAnimation;
        if (current != null) {
            this.currentAnimation = null;
            this.setFraction(1.0f);
            this.seekToFraction();
        }
    }

    @Override
    public void transitionConfigured$animation_core(@NotNull Transition<S> transition) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        boolean value$iv = this.transition == null || Intrinsics.areEqual(transition, this.transition);
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("An instance of SeekableTransitionState has been used in different Transitions. Previous instance: " + this.transition + ", new instance: " + transition);
        }
        this.transition = transition;
    }

    @Override
    public void transitionRemoved$animation_core() {
        this.transition = null;
        TransitionKt.getSeekableStateObserver().clear(this);
    }

    public final void observeTotalDuration$animation_core() {
        TransitionKt.getSeekableStateObserver().observeReads(this, TransitionKt.access$getSeekableTransitionStateTotalDurationChanged$p(), this.recalculateTotalDurationNanos);
    }

    public final void onTotalDurationChanged$animation_core() {
        long previousTotalDurationNanos = this.totalDurationNanos;
        this.observeTotalDuration$animation_core();
        if (previousTotalDurationNanos != this.totalDurationNanos) {
            SeekingAnimationState animation = this.currentAnimation;
            if (animation != null) {
                if (animation.getProgressNanos() > this.totalDurationNanos) {
                    this.endAllAnimations();
                } else {
                    animation.setDurationNanos(this.totalDurationNanos);
                    if (animation.getAnimationSpec() == null) {
                        animation.setAnimationSpecDuration(MathKt.roundToLong((double)((1.0 - (double)animation.getStart().get$animation_core(0)) * (double)this.totalDurationNanos)));
                    }
                }
            } else if (this.totalDurationNanos != 0L) {
                this.seekToFraction();
            }
        }
    }

    private final void seekToFraction() {
        Transition<S> transition = this.transition;
        if (transition == null) {
            return;
        }
        Transition<S> transition2 = transition;
        long playTimeNanos = MathKt.roundToLong((double)((double)this.getFraction() * (double)transition2.getTotalDurationNanos()));
        transition2.seekAnimations$animation_core(playTimeNanos);
    }

    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class SeekingAnimationState {
        private long progressNanos;
        @Nullable
        private VectorizedAnimationSpec<AnimationVector1D> animationSpec;
        private boolean isComplete;
        private float value;
        @NotNull
        private AnimationVector1D start;
        @Nullable
        private AnimationVector1D initialVelocity;
        private long durationNanos;
        private long animationSpecDuration;
        public static final int $stable = 8;

        public final long getProgressNanos() {
            return this.progressNanos;
        }

        @Nullable
        public final VectorizedAnimationSpec<AnimationVector1D> getAnimationSpec() {
            return this.animationSpec;
        }

        @NotNull
        public final AnimationVector1D getStart() {
            return this.start;
        }

        public final void setDurationNanos(long l) {
            this.durationNanos = l;
        }

        public final void setAnimationSpecDuration(long l) {
            this.animationSpecDuration = l;
        }

        @NotNull
        public String toString() {
            return "progress nanos: " + this.progressNanos + ", animationSpec: " + this.animationSpec + ", isComplete: " + this.isComplete + ", value: " + this.value + ", start: " + this.start + ", initialVelocity: " + this.initialVelocity + ", durationNanos: " + this.durationNanos + ", animationSpecDuration: " + this.animationSpecDuration;
        }
    }
}

