/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.RepeatMode;
import androidx.compose.animation.core.StartOffset;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedInfiniteRepeatableSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InfiniteRepeatableSpec<T>
implements AnimationSpec<T> {
    @NotNull
    private final DurationBasedAnimationSpec<T> animation;
    @NotNull
    private final RepeatMode repeatMode;
    private final long initialStartOffset;
    public static final int $stable = 8;

    private InfiniteRepeatableSpec(DurationBasedAnimationSpec<T> animation, RepeatMode repeatMode, long initialStartOffset) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.animation = animation;
        this.repeatMode = repeatMode;
        this.initialStartOffset = initialStartOffset;
    }

    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedAnimationSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        return new VectorizedInfiniteRepeatableSpec(this.animation.vectorize(converter), this.repeatMode, this.initialStartOffset, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof InfiniteRepeatableSpec ? Intrinsics.areEqual(((InfiniteRepeatableSpec)other).animation, this.animation) && ((InfiniteRepeatableSpec)other).repeatMode == this.repeatMode && StartOffset.equals-impl0(((InfiniteRepeatableSpec)other).initialStartOffset, this.initialStartOffset) : false;
    }

    public int hashCode() {
        return (this.animation.hashCode() * 31 + this.repeatMode.hashCode()) * 31 + StartOffset.hashCode-impl(this.initialStartOffset);
    }

    public /* synthetic */ InfiniteRepeatableSpec(DurationBasedAnimationSpec animation, RepeatMode repeatMode, long initialStartOffset, DefaultConstructorMarker $constructor_marker) {
        this(animation, repeatMode, initialStartOffset);
    }
}

