/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.FloatAnimationSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nFloatAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n+ 3 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n*L\n1#1,260:1\n223#1:261\n223#1:283\n119#2,10:262\n119#2,10:273\n119#2,10:284\n71#3:272\n*S KotlinDebug\n*F\n+ 1 FloatAnimationSpec.kt\nandroidx/compose/animation/core/FloatTweenSpec\n*L\n216#1:261\n244#1:283\n216#1:262,10\n223#1:273,10\n244#1:284,10\n219#1:272\n*E\n"})
public final class FloatTweenSpec
implements FloatAnimationSpec {
    private final int duration;
    private final int delay;
    @NotNull
    private final Easing easing;
    private final long durationNanos;
    private final long delayNanos;

    public FloatTweenSpec(int duration, int delay, @NotNull Easing easing) {
        Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
        this.duration = duration;
        this.delay = delay;
        this.easing = easing;
        this.durationNanos = (long)this.duration * 1000000L;
        this.delayNanos = (long)this.delay * 1000000L;
    }

    public /* synthetic */ FloatTweenSpec(int n, int n2, Easing easing, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 300;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            easing = EasingKt.getFastOutSlowInEasing();
        }
        this(n, n2, easing);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        FloatTweenSpec this_$iv = this;
        boolean $i$f$clampPlayTimeNanos = false;
        long l = playTimeNanos - this_$iv.delayNanos;
        long l2 = 0L;
        long maximumValue$iv$iv = this_$iv.durationNanos;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        long clampedPlayTimeNanos = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        float rawFraction = this.duration == 0 ? 1.0f : (float)clampedPlayTimeNanos / (float)this.durationNanos;
        float fraction = this.easing.transform(rawFraction);
        boolean $i$f$lerp = false;
        return initialValue * (1.0f - fraction) + targetValue * fraction;
    }

    @Override
    public long getDurationNanos(float initialValue, float targetValue, float initialVelocity) {
        return this.delayNanos + this.durationNanos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float targetValue, float initialVelocity) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        FloatTweenSpec this_$iv = this;
        boolean $i$f$clampPlayTimeNanos = false;
        long l = playTimeNanos - this_$iv.delayNanos;
        long l2 = 0L;
        long maximumValue$iv$iv = this_$iv.durationNanos;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        long clampedPlayTimeNanos = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        if (clampedPlayTimeNanos == 0L) {
            return initialVelocity;
        }
        float startNum = this.getValueFromNanos(clampedPlayTimeNanos - 1000000L, initialValue, targetValue, initialVelocity);
        float endNum = this.getValueFromNanos(clampedPlayTimeNanos, initialValue, targetValue, initialVelocity);
        return (endNum - startNum) * 1000.0f;
    }

    public FloatTweenSpec() {
        this(0, 0, null, 7, null);
    }
}

