/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nAnimationState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationState.kt\nandroidx/compose/animation/core/AnimationScope\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,329:1\n85#2:330\n113#2,2:331\n85#2:333\n113#2,2:334\n*S KotlinDebug\n*F\n+ 1 AnimationState.kt\nandroidx/compose/animation/core/AnimationScope\n*L\n129#1:330\n129#1:331,2\n161#1:333\n161#1:334,2\n*E\n"})
public final class AnimationScope<T, V extends AnimationVector> {
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    private final T targetValue;
    private final long startTimeNanos;
    @NotNull
    private final Function0<Unit> onCancel;
    @NotNull
    private final MutableState value$delegate;
    @NotNull
    private V velocityVector;
    private long lastFrameTimeNanos;
    private long finishedTimeNanos;
    @NotNull
    private final MutableState isRunning$delegate;
    public static final int $stable = 8;

    public AnimationScope(T initialValue, @NotNull TwoWayConverter<T, V> typeConverter, @NotNull V initialVelocityVector, long lastFrameTimeNanos, T targetValue, long startTimeNanos, boolean isRunning, @NotNull Function0<Unit> onCancel) {
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
        Intrinsics.checkNotNullParameter(onCancel, (String)"onCancel");
        this.typeConverter = typeConverter;
        this.targetValue = targetValue;
        this.startTimeNanos = startTimeNanos;
        this.onCancel = onCancel;
        this.value$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
        this.velocityVector = AnimationVectorsKt.copy(initialVelocityVector);
        this.lastFrameTimeNanos = lastFrameTimeNanos;
        this.finishedTimeNanos = Long.MIN_VALUE;
        this.isRunning$delegate = SnapshotStateKt.mutableStateOf$default(isRunning, null, 2, null);
    }

    public final long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    /*
     * WARNING - void declaration
     */
    public final T getValue() {
        void $this$getValue$iv;
        State state2 = this.value$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue$animation_core(T t2) {
        void $this$setValue$iv;
        MutableState mutableState = this.value$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(t2);
    }

    @NotNull
    public final V getVelocityVector() {
        return this.velocityVector;
    }

    public final void setVelocityVector$animation_core(@NotNull V v) {
        Intrinsics.checkNotNullParameter(v, (String)"<set-?>");
        this.velocityVector = v;
    }

    public final long getLastFrameTimeNanos() {
        return this.lastFrameTimeNanos;
    }

    public final void setLastFrameTimeNanos$animation_core(long l) {
        this.lastFrameTimeNanos = l;
    }

    public final long getFinishedTimeNanos() {
        return this.finishedTimeNanos;
    }

    public final void setFinishedTimeNanos$animation_core(long l) {
        this.finishedTimeNanos = l;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRunning() {
        void $this$getValue$iv;
        State state2 = this.isRunning$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setRunning$animation_core(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isRunning$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    public final T getVelocity() {
        return (T)this.typeConverter.getConvertFromVector().invoke(this.velocityVector);
    }

    public final void cancelAnimation() {
        this.setRunning$animation_core(false);
        this.onCancel.invoke();
    }
}

