/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimatableKt;
import androidx.compose.animation.core.Animation;
import androidx.compose.animation.core.AnimationEndReason;
import androidx.compose.animation.core.AnimationKt;
import androidx.compose.animation.core.AnimationResult;
import androidx.compose.animation.core.AnimationScope;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationState;
import androidx.compose.animation.core.AnimationStateKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVector1D;
import androidx.compose.animation.core.AnimationVector2D;
import androidx.compose.animation.core.AnimationVector3D;
import androidx.compose.animation.core.MutatorMutex;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.CancellationException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnimatable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Animatable.kt\nandroidx/compose/animation/core/Animatable\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Preconditions.kt\nandroidx/compose/animation/core/PreconditionsKt\n*L\n1#1,492:1\n85#2:493\n113#2,2:494\n85#2:496\n113#2,2:497\n1#3:499\n53#4,4:500\n*S KotlinDebug\n*F\n+ 1 Animatable.kt\nandroidx/compose/animation/core/Animatable\n*L\n86#1:493\n86#1:494,2\n93#1:496\n93#1:497,2\n171#1:500,4\n*E\n"})
public final class Animatable<T, V extends AnimationVector> {
    @NotNull
    private final TwoWayConverter<T, V> typeConverter;
    @Nullable
    private final T visibilityThreshold;
    @NotNull
    private final String label;
    @NotNull
    private final AnimationState<T, V> internalState;
    @NotNull
    private final MutableState isRunning$delegate;
    @NotNull
    private final MutableState targetValue$delegate;
    @NotNull
    private final MutatorMutex mutatorMutex;
    @NotNull
    private final SpringSpec<T> defaultSpringSpec;
    @NotNull
    private final V negativeInfinityBounds;
    @NotNull
    private final V positiveInfinityBounds;
    @NotNull
    private V lowerBoundVector;
    @NotNull
    private V upperBoundVector;
    public static final int $stable = 8;

    public Animatable(T initialValue, @NotNull TwoWayConverter<T, V> typeConverter, @Nullable T visibilityThreshold, @NotNull String label) {
        Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.typeConverter = typeConverter;
        this.visibilityThreshold = visibilityThreshold;
        this.label = label;
        this.internalState = new AnimationState(this.typeConverter, initialValue, null, 0L, 0L, false, 60, null);
        this.isRunning$delegate = SnapshotStateKt.mutableStateOf$default(false, null, 2, null);
        this.targetValue$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
        this.mutatorMutex = new MutatorMutex();
        this.defaultSpringSpec = new SpringSpec(0.0f, 0.0f, this.visibilityThreshold, 3, null);
        V v = this.getVelocityVector();
        AnimationVector animationVector = v instanceof AnimationVector1D ? (AnimationVector)AnimatableKt.access$getNegativeInfinityBounds1D$p() : (v instanceof AnimationVector2D ? (AnimationVector)AnimatableKt.access$getNegativeInfinityBounds2D$p() : (v instanceof AnimationVector3D ? (AnimationVector)AnimatableKt.access$getNegativeInfinityBounds3D$p() : (AnimationVector)AnimatableKt.access$getNegativeInfinityBounds4D$p()));
        Intrinsics.checkNotNull((Object)animationVector, (String)"null cannot be cast to non-null type V of androidx.compose.animation.core.Animatable");
        this.negativeInfinityBounds = animationVector;
        v = this.getVelocityVector();
        animationVector = v instanceof AnimationVector1D ? (AnimationVector)AnimatableKt.access$getPositiveInfinityBounds1D$p() : (v instanceof AnimationVector2D ? (AnimationVector)AnimatableKt.access$getPositiveInfinityBounds2D$p() : (v instanceof AnimationVector3D ? (AnimationVector)AnimatableKt.access$getPositiveInfinityBounds3D$p() : (AnimationVector)AnimatableKt.access$getPositiveInfinityBounds4D$p()));
        Intrinsics.checkNotNull((Object)animationVector, (String)"null cannot be cast to non-null type V of androidx.compose.animation.core.Animatable");
        this.positiveInfinityBounds = animationVector;
        this.lowerBoundVector = this.negativeInfinityBounds;
        this.upperBoundVector = this.positiveInfinityBounds;
    }

    public /* synthetic */ Animatable(Object object, TwoWayConverter twoWayConverter, Object object2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            object2 = null;
        }
        if ((n & 8) != 0) {
            string = "Animatable";
        }
        this(object, twoWayConverter, object2, string);
    }

    @NotNull
    public final TwoWayConverter<T, V> getTypeConverter() {
        return this.typeConverter;
    }

    @NotNull
    public final AnimationState<T, V> getInternalState$animation_core() {
        return this.internalState;
    }

    public final T getValue() {
        return this.internalState.getValue();
    }

    @NotNull
    public final V getVelocityVector() {
        return this.internalState.getVelocityVector();
    }

    public final T getVelocity() {
        return (T)this.typeConverter.getConvertFromVector().invoke(this.getVelocityVector());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isRunning() {
        void $this$getValue$iv;
        State state2 = this.isRunning$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setRunning(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isRunning$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final T getTargetValue() {
        void $this$getValue$iv;
        State state2 = this.targetValue$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setTargetValue(T t2) {
        void $this$setValue$iv;
        MutableState mutableState = this.targetValue$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(t2);
    }

    @Nullable
    public final Object animateTo(T targetValue, @NotNull AnimationSpec<T> animationSpec, T initialVelocity, @Nullable Function1<? super Animatable<T, V>, Unit> block, @NotNull Continuation<? super AnimationResult<T, V>> $completion) {
        T t2 = this.getValue();
        TwoWayConverter<T, V> twoWayConverter = this.typeConverter;
        TargetBasedAnimation<T, V> anim = AnimationKt.TargetBasedAnimation(animationSpec, twoWayConverter, t2, targetValue, initialVelocity);
        return this.runAnimation(anim, initialVelocity, block, $completion);
    }

    public static /* synthetic */ Object animateTo$default(Animatable animatable, Object object, AnimationSpec animationSpec, Object object2, Function1 function1, Continuation continuation, int n, Object object3) {
        if ((n & 2) != 0) {
            animationSpec = animatable.defaultSpringSpec;
        }
        if ((n & 4) != 0) {
            object2 = animatable.getVelocity();
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return animatable.animateTo(object, animationSpec, object2, function1, continuation);
    }

    private final Object runAnimation(Animation<T, V> animation, T initialVelocity, Function1<? super Animatable<T, V>, Unit> block, Continuation<? super AnimationResult<T, V>> $completion) {
        long startTime = this.internalState.getLastFrameTimeNanos();
        return MutatorMutex.mutate$default(this.mutatorMutex, null, new Function1<Continuation<? super AnimationResult<T, V>>, Object>(this, initialVelocity, animation, startTime, block, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Animatable<T, V> this$0;
            final /* synthetic */ T $initialVelocity;
            final /* synthetic */ Animation<T, V> $animation;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Function1<Animatable<T, V>, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$initialVelocity = $initialVelocity;
                this.$animation = $animation;
                this.$startTime = $startTime;
                this.$block = $block;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.this$0.getInternalState$animation_core().setVelocityVector$animation_core((AnimationVector)this.this$0.getTypeConverter().getConvertToVector().invoke(this.$initialVelocity));
                        Animatable.access$setTargetValue(this.this$0, this.$animation.getTargetValue());
                        Animatable.access$setRunning(this.this$0, true);
                        endState = AnimationStateKt.copy$default(this.this$0.getInternalState$animation_core(), null, null, 0L, -9223372036854775808L, false, 23, null);
                        clampingNeeded = new Ref.BooleanRef();
                        this.L$0 = endState;
                        this.L$1 = clampingNeeded;
                        this.label = 1;
                        v0 = SuspendAnimationKt.animate(endState, this.$animation, this.$startTime, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(androidx.compose.animation.core.Animatable androidx.compose.animation.core.AnimationState kotlin.jvm.functions.Function1 kotlin.jvm.internal.Ref$BooleanRef androidx.compose.animation.core.AnimationScope ), (Landroidx/compose/animation/core/AnimationScope;)Lkotlin/Unit;)(this.this$0, (AnimationState)endState, this.$block, (Ref.BooleanRef)clampingNeeded), (Continuation<? super Unit>)((Continuation)this));
                        ** if (v0 != var5_2) goto lbl18
lbl17:
                        // 1 sources

                        return var5_2;
lbl18:
                        // 1 sources

                        ** GOTO lbl26
                    }
                    case 1: {
                        clampingNeeded = (Ref.BooleanRef)this.L$1;
                        endState = (AnimationState)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            endReason = clampingNeeded.element != false ? AnimationEndReason.BoundReached : AnimationEndReason.Finished;
                            Animatable.access$endAnimation(this.this$0);
                            var2_3 = new AnimationResult<T, V>(endState, endReason);
                        }
                        catch (CancellationException e) {
                            Animatable.access$endAnimation(this.this$0);
                            throw e;
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super AnimationResult<T, V>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Animatable this$0, AnimationState $endState, Function1 $block, Ref.BooleanRef $clampingNeeded, AnimationScope $this$animate) {
                block2: {
                    block1: {
                        SuspendAnimationKt.updateState($this$animate, this$0.getInternalState$animation_core());
                        Object clamped = Animatable.access$clampToBounds(this$0, $this$animate.getValue());
                        if (Intrinsics.areEqual((Object)clamped, $this$animate.getValue())) break block1;
                        this$0.getInternalState$animation_core().setValue$animation_core(clamped);
                        $endState.setValue$animation_core(clamped);
                        Function1 function1 = $block;
                        if (function1 != null) {
                            function1.invoke((Object)this$0);
                        }
                        $this$animate.cancelAnimation();
                        $clampingNeeded.element = true;
                        break block2;
                    }
                    Function1 function1 = $block;
                    if (function1 == null) break block2;
                    function1.invoke((Object)this$0);
                }
                return Unit.INSTANCE;
            }
        }, $completion, 1, null);
    }

    private final T clampToBounds(T value2) {
        if (Intrinsics.areEqual(this.lowerBoundVector, this.negativeInfinityBounds) && Intrinsics.areEqual(this.upperBoundVector, this.positiveInfinityBounds)) {
            return value2;
        }
        AnimationVector valueVector = (AnimationVector)this.typeConverter.getConvertToVector().invoke(value2);
        boolean clamped = false;
        int n = valueVector.getSize$animation_core();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!(valueVector.get$animation_core(i2) < ((AnimationVector)this.lowerBoundVector).get$animation_core(i2)) && !(valueVector.get$animation_core(i2) > ((AnimationVector)this.upperBoundVector).get$animation_core(i2))) continue;
            clamped = true;
            valueVector.set$animation_core(i2, RangesKt.coerceIn((float)valueVector.get$animation_core(i2), (float)((AnimationVector)this.lowerBoundVector).get$animation_core(i2), (float)((AnimationVector)this.upperBoundVector).get$animation_core(i2)));
        }
        if (clamped) {
            return (T)this.typeConverter.getConvertFromVector().invoke((Object)valueVector);
        }
        return value2;
    }

    private final void endAnimation() {
        AnimationState<T, V> animationState;
        AnimationState<T, V> $this$endAnimation_u24lambda_u243 = animationState = this.internalState;
        boolean bl = false;
        ((AnimationVector)$this$endAnimation_u24lambda_u243.getVelocityVector()).reset$animation_core();
        $this$endAnimation_u24lambda_u243.setLastFrameTimeNanos$animation_core(Long.MIN_VALUE);
        this.setRunning(false);
    }

    @Nullable
    public final Object snapTo(T targetValue, @NotNull Continuation<? super Unit> $completion) {
        Object object = MutatorMutex.mutate$default(this.mutatorMutex, null, (Function1)new Function1<Continuation<? super Unit>, Object>(this, targetValue, null){
            int label;
            final /* synthetic */ Animatable<T, V> this$0;
            final /* synthetic */ T $targetValue;
            {
                this.this$0 = $receiver;
                this.$targetValue = $targetValue;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Animatable.access$endAnimation(this.this$0);
                        Object clampedValue = Animatable.access$clampToBounds(this.this$0, this.$targetValue);
                        this.this$0.getInternalState$animation_core().setValue$animation_core(clampedValue);
                        Animatable.access$setTargetValue(this.this$0, clampedValue);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        Object object = MutatorMutex.mutate$default(this.mutatorMutex, null, (Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ Animatable<T, V> this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Animatable.access$endAnimation(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 1, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final State<T> asState() {
        return this.internalState;
    }

    public static final /* synthetic */ void access$setTargetValue(Animatable $this, Object object) {
        $this.setTargetValue(object);
    }

    public static final /* synthetic */ void access$setRunning(Animatable $this, boolean bl) {
        $this.setRunning(bl);
    }

    public static final /* synthetic */ void access$endAnimation(Animatable $this) {
        $this.endAnimation();
    }

    public static final /* synthetic */ Object access$clampToBounds(Animatable $this, Object value2) {
        return $this.clampToBounds(value2);
    }
}

