/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.AndroidFlingSpline;
import androidx.compose.animation.FlingCalculatorKt;
import androidx.compose.ui.unit.Density;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlingCalculator {
    private final float friction;
    @NotNull
    private final Density density;
    private final float magicPhysicalCoefficient;

    public FlingCalculator(float friction, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.friction = friction;
        this.density = density;
        this.magicPhysicalCoefficient = this.computeDeceleration(this.density);
    }

    private final float computeDeceleration(Density density) {
        return FlingCalculatorKt.access$computeDeceleration(0.84f, density.getDensity());
    }

    private final double getSplineDeceleration(float velocity) {
        return AndroidFlingSpline.INSTANCE.deceleration(velocity, this.friction * this.magicPhysicalCoefficient);
    }

    public final long flingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (long)(1000.0 * Math.exp(l / decelMinusOne));
    }

    public final float flingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l));
    }

    @NotNull
    public final FlingInfo flingInfo(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return new FlingInfo(velocity, (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l)), (long)(1000.0 * Math.exp(l / decelMinusOne)));
    }

    public static final class FlingInfo {
        private final float initialVelocity;
        private final float distance;
        private final long duration;

        public FlingInfo(float initialVelocity, float distance, long duration) {
            this.initialVelocity = initialVelocity;
            this.distance = distance;
            this.duration = duration;
        }

        public final float position(long time2) {
            float splinePos = this.duration > 0L ? (float)time2 / (float)this.duration : 1.0f;
            return this.distance * Math.signum(this.initialVelocity) * AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getDistanceCoefficient();
        }

        public final float velocity(long time2) {
            float splinePos = this.duration > 0L ? (float)time2 / (float)this.duration : 1.0f;
            return AndroidFlingSpline.INSTANCE.flingPosition(splinePos).getVelocityCoefficient() * Math.signum(this.initialVelocity) * this.distance / (float)this.duration * 1000.0f;
        }

        @NotNull
        public String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ")";
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.initialVelocity);
            result2 = result2 * 31 + Float.hashCode(this.distance);
            result2 = result2 * 31 + Long.hashCode(this.duration);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            FlingInfo flingInfo = (FlingInfo)other;
            if (Float.compare(this.initialVelocity, flingInfo.initialVelocity) != 0) {
                return false;
            }
            if (Float.compare(this.distance, flingInfo.distance) != 0) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

