/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.EdgeMode;
import com.github.weisj.jsvg.attributes.filter.LayoutBounds;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.InplaceBoxBlurFilter;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.filter.AbstractFilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.filter.MultiConvolveOp;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.ConvolveOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={Animate.class, Set.class})
public final class FeGaussianBlur
extends AbstractFilterPrimitive {
    public static final String TAG = "fegaussianblur";
    private static final double SQRT_2_PI = Math.sqrt(Math.PI * 2);
    private static final double THREE_QUARTER_SQRT_2_PI = SQRT_2_PI * 3.0 / 4.0;
    private static final float KERNEL_PRECISION = 0.001f;
    private static final double BOX_BLUR_APPROXIMATION_THRESHOLD = 2.0;
    private float[] stdDeviation;
    private EdgeMode edgeMode;
    private double xCurrent;
    private double yCurrent;
    private Kernel xBlur;
    private Kernel yBlur;
    private boolean onlyAlpha;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.stdDeviation = attributeNode.getFloatList("stdDeviation");
        this.edgeMode = attributeNode.getEnum("edgeMode", EdgeMode.Duplicate);
    }

    @ApiStatus.Internal
    public void setOnlyAlpha(boolean onlyAlpha) {
        this.onlyAlpha = onlyAlpha;
    }

    private double[] computeAbsoluteStdDeviation(@Nullable AffineTransform at) {
        if (this.stdDeviation.length == 0) {
            return new double[]{0.0, 0.0};
        }
        double xSigma = this.stdDeviation[0];
        double ySigma = this.stdDeviation[Math.min(this.stdDeviation.length - 1, 1)];
        if (at != null) {
            xSigma *= GeometryUtil.scaleXOfTransform(at);
            ySigma *= GeometryUtil.scaleYOfTransform(at);
        }
        return new double[]{xSigma, ySigma};
    }

    @Override
    public void layoutFilter(@NotNull RenderContext context, @NotNull FilterLayoutContext filterLayoutContext) {
        LayoutBounds input = this.impl().layoutInput(filterLayoutContext);
        double[] sigma = this.computeAbsoluteStdDeviation(null);
        int hExtend = FeGaussianBlur.kernelDiameterForStandardDeviation(sigma[0]);
        int vExtend = FeGaussianBlur.kernelDiameterForStandardDeviation(sigma[1]);
        this.impl().saveLayoutResult(input.grow(hExtend, vExtend, filterLayoutContext), filterLayoutContext);
    }

    @Override
    public void applyFilter(@NotNull RenderContext context, @NotNull FilterContext filterContext) {
        if (this.stdDeviation.length == 0) {
            this.impl().noop(filterContext);
            return;
        }
        double[] sigma = this.computeAbsoluteStdDeviation(filterContext.info().output().transform());
        double xSigma = sigma[0];
        double ySigma = sigma[1];
        if (xSigma <= 0.0 && ySigma <= 0.0) {
            this.impl().noop(filterContext);
            return;
        }
        Channel inputChannel = this.impl().inputChannel(filterContext);
        if (this.onlyAlpha) {
            inputChannel = inputChannel.alphaChannel();
        }
        ImageProducer input = inputChannel.producer();
        Kernel xBlurKernel = null;
        Kernel yBlurKernel = null;
        int dX = FeGaussianBlur.kernelDiameterForStandardDeviation(xSigma);
        int dY = FeGaussianBlur.kernelDiameterForStandardDeviation(ySigma);
        if (xSigma > 0.0 && xSigma < 2.0) {
            xBlurKernel = this.createConvolveKernel(dX, xSigma, true);
        }
        if (ySigma > 0.0 && ySigma < 2.0) {
            yBlurKernel = this.createConvolveKernel(dX, ySigma, false);
        }
        ImageProducer output = this.edgeMode.convolve(context, filterContext, input, new MixedQualityConvolveOperation(xBlurKernel, yBlurKernel, dX, dY));
        this.impl().saveResult(new ImageProducerChannel(output), filterContext);
    }

    @NotNull
    private Kernel createConvolveKernel(int diameter, double sigma, boolean horizontal) {
        if (horizontal && this.xBlur != null && this.xCurrent == sigma) {
            return this.xBlur;
        }
        if (!horizontal && this.yBlur != null && this.yCurrent == sigma) {
            return this.yBlur;
        }
        if (horizontal) {
            this.xCurrent = sigma;
        } else {
            this.yCurrent = sigma;
        }
        float[] data = FeGaussianBlur.computeGaussianKernelData(diameter, sigma);
        if (horizontal) {
            this.xBlur = new Kernel(diameter, 1, data);
        } else {
            this.yBlur = new Kernel(1, diameter, data);
        }
        return horizontal ? this.xBlur : this.yBlur;
    }

    private static float normalConvolve(float x, double standardDeviation) {
        return (float)(Math.pow(Math.E, (double)(-x * x) / (2.0 * standardDeviation * standardDeviation)) / (standardDeviation * SQRT_2_PI));
    }

    private static float[] computeGaussianKernelData(int diameter, double standardDeviation) {
        int i;
        float[] data = new float[diameter];
        int mid = diameter / 2;
        float total = 0.0f;
        for (i = 0; i < diameter; ++i) {
            data[i] = FeGaussianBlur.normalConvolve((float)i - (float)mid, standardDeviation);
            total += data[i];
        }
        if (total > 0.0f) {
            i = 0;
            while (i < diameter) {
                int n = i++;
                data[n] = data[n] / total;
            }
        }
        return data;
    }

    public static int kernelDiameterForStandardDeviation(double standardDeviation) {
        if (standardDeviation < 2.0) {
            float areaSum = (float)(0.5 / (standardDeviation * SQRT_2_PI));
            int i = 0;
            while ((double)areaSum < 0.49899999995250255) {
                areaSum += FeGaussianBlur.normalConvolve(i, standardDeviation);
                ++i;
            }
            return i * 2 + 1;
        }
        return (int)Math.floor(THREE_QUARTER_SQRT_2_PI * standardDeviation + 0.5);
    }

    private static final class MixedQualityConvolveOperation
    implements EdgeMode.ConvolveOperation {
        @Nullable
        private final Kernel xKernel;
        @Nullable
        private final Kernel yKernel;
        private final int dX;
        private final int dY;

        private MixedQualityConvolveOperation(@Nullable Kernel xKernel, @Nullable Kernel yKernel, int dX, int dY) {
            this.xKernel = xKernel;
            this.yKernel = yKernel;
            this.dX = dX;
            this.dY = dY;
        }

        @Override
        @NotNull
        public Dimension maximumKernelSize() {
            return new Dimension(this.xKernel != null ? this.xKernel.getXOrigin() : this.dX, this.yKernel != null ? this.yKernel.getXOrigin() : this.dY);
        }

        @Override
        @NotNull
        public ImageProducer convolve(@NotNull BufferedImage image, @Nullable RenderingHints hints, int awtEdgeMode) {
            WritableRaster raster = image.getRaster();
            if (!image.getColorModel().isAlphaPremultiplied()) {
                throw new IllegalStateException("Image should be premultiplied");
            }
            if (this.xKernel != null && this.yKernel != null) {
                MultiConvolveOp op = new MultiConvolveOp(new ConvolveOp[]{new ConvolveOp(this.xKernel, awtEdgeMode, hints), new ConvolveOp(this.yKernel, awtEdgeMode, hints)});
                return new FilteredImageSource(image.getSource(), new BufferedImageFilter(op));
            }
            if (this.xKernel != null) {
                this.verticalBoxBlur(raster);
                return new FilteredImageSource(image.getSource(), new BufferedImageFilter(new ConvolveOp(this.xKernel, awtEdgeMode, hints)));
            }
            if (this.yKernel != null) {
                this.horizontalBoxBlur(raster);
                return new FilteredImageSource(image.getSource(), new BufferedImageFilter(new ConvolveOp(this.yKernel, awtEdgeMode, hints)));
            }
            this.horizontalBoxBlur(raster);
            this.verticalBoxBlur(raster);
            return image.getSource();
        }

        private void horizontalBoxBlur(@NotNull WritableRaster raster) {
            if ((this.dX & 1) == 0) {
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX, this.dX / 2);
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX, this.dX / 2 - 1);
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX + 1, this.dX / 2);
            } else {
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX, this.dX / 2);
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX, this.dX / 2);
                InplaceBoxBlurFilter.horizontalPass(raster, raster, 0, 0, this.dX, this.dX / 2);
            }
        }

        private void verticalBoxBlur(@NotNull WritableRaster raster) {
            if ((this.dY & 1) == 0) {
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY, this.dY / 2);
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY, this.dY / 2 - 1);
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY + 1, this.dY / 2);
            } else {
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY, this.dY / 2);
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY, this.dY / 2);
                InplaceBoxBlurFilter.verticalPass(raster, raster, 0, 0, this.dY, this.dY / 2);
            }
        }
    }
}

