/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.io.ByteArrayInputStream;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.digest.DigestUtils;
import org.jetbrains.zip.signer.exceptions.ZipVerificationException;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.InvalidSignatureResult;
import org.jetbrains.zip.signer.verifier.MissingSignatureResult;
import org.jetbrains.zip.signer.verifier.SuccessfulVerificationResult;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;
import org.jetbrains.zip.signer.zip.ZipUtils;

@ExperimentalUnsignedTypes
@SourceDebugExtension(value={"SMAP\nZipVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipVerifier.kt\norg/jetbrains/zip/signer/verifier/ZipVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n1#2:140\n1747#3,3:141\n1194#3,2:144\n1222#3,4:146\n1549#3:150\n1620#3,3:151\n1549#3:154\n1620#3,3:155\n1855#3,2:158\n1549#3:160\n1620#3,3:161\n1855#3,2:164\n*S KotlinDebug\n*F\n+ 1 ZipVerifier.kt\norg/jetbrains/zip/signer/verifier/ZipVerifier\n*L\n82#1:141,3\n89#1:144,2\n89#1:146,4\n91#1:150\n91#1:151,3\n106#1:154\n106#1:155,3\n113#1:158,2\n126#1:160\n126#1:161,3\n131#1:164,2\n*E\n"})
public final class ZipVerifier {
    @NotNull
    public static final ZipVerifier INSTANCE = new ZipVerifier();

    private ZipVerifier() {
    }

    @NotNull
    public final ZipVerificationResult verify(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        ZipSectionsInformation zipSectionsInformation = ZipUtils.INSTANCE.findZipSectionsInformation(dataSource);
        ZipMetadata zipMetadata = ZipMetadata.Companion.findInZip(dataSource, zipSectionsInformation);
        if (zipMetadata == null) {
            return MissingSignatureResult.INSTANCE;
        }
        ZipMetadata zipMetadata2 = zipMetadata;
        ZipSections zipSections = ZipUtils.INSTANCE.findZipSections$lib(dataSource, zipSectionsInformation, zipMetadata2);
        return this.verify(zipSections, zipMetadata2);
    }

    private final ZipVerificationResult verify(ZipSections zipSections, ZipMetadata zipMetadata) {
        ZipVerificationResult zipVerificationResult;
        try {
            this.checkDigests$lib(zipSections, zipMetadata);
            List<List<X509Certificate>> certificateChains = this.verifySignatures(zipMetadata);
            this.verifyCertificateChains(certificateChains);
            zipVerificationResult = new SuccessfulVerificationResult(certificateChains);
        }
        catch (ZipVerificationException e) {
            zipVerificationResult = new InvalidSignatureResult(e.getMessage());
        }
        return zipVerificationResult;
    }

    private final void verifyCertificateChains(List<? extends List<? extends Certificate>> certificateChains) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = certificateChains;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl2 = false;
                    if (!(!CertificateUtils.INSTANCE.isValidCertificateChain(it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new ZipVerificationException("One of signature blocks contains invalid certificate chain", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<X509Certificate>> verifySignatures(ZipMetadata zipMetadata) {
        List list2;
        Object object;
        void $this$associateByTo$iv$iv;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Iterable $this$associateBy$iv = zipMetadata.getDigests();
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Digest digest = (Digest)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getAlgorithm(), element$iv$iv);
        }
        Map digests = destination$iv$iv;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = zipMetadata.getSigners();
            boolean $i$f$map = false;
            Iterable capacity$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (SignerBlock)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)certFactory);
                object.add(INSTANCE.verifySignatures(digests, (SignerBlock)it, certFactory));
            }
            list2 = (List)destination$iv$iv2;
        }
        catch (SignatureException e) {
            throw new ZipVerificationException("Failed to verify signatures: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ZipVerificationException("Failed to verify signatures: " + e.getMessage(), e);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509Certificate> verifySignatures(Map<ContentDigestAlgorithm, Digest> digests, SignerBlock signer, CertificateFactory certFactory) {
        void $this$mapTo$iv$iv;
        if (signer.getSignatures().isEmpty()) {
            throw new ZipVerificationException("Signer block contains no signatures", null, 2, null);
        }
        Iterable $this$map$iv = signer.getEncodedCertificates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Certificate certificate2 = certFactory.generateCertificate(new ByteArrayInputStream((byte[])it));
            Intrinsics.checkNotNull((Object)certificate2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            collection.add((X509Certificate)certificate2);
        }
        List certificates = (List)destination$iv$iv;
        if (certificates.isEmpty()) {
            throw new ZipVerificationException("Signer has no certificates", null, 2, null);
        }
        Iterable $this$forEach$iv = signer.getSignatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest digest;
            SignatureData signature = (SignatureData)element$iv;
            boolean bl = false;
            SignatureAlgorithm signatureAlgorithm = signature.getAlgorithm();
            if (digests.get((Object)signature.getAlgorithm().getContentDigestAlgorithm()) == null) {
                throw new ZipVerificationException("Missing digest " + (Object)((Object)signature.getAlgorithm().getContentDigestAlgorithm()), null, 2, null);
            }
            new DefaultSignatureVerifier(certificates, signatureAlgorithm).verify(digest.getDigestBytes(), signature.getSignatureBytes());
        }
        return certificates;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkDigests$lib(@NotNull ZipSections zipSections, @NotNull ZipMetadata zipMetadata) {
        List $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)zipSections, (String)"zipSections");
        Intrinsics.checkNotNullParameter((Object)zipMetadata, (String)"zipMetadata");
        try {
            void $this$mapTo$iv$iv;
            Iterable iterable = zipMetadata.getDigests();
            DigestUtils digestUtils = DigestUtils.INSTANCE;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Digest digest = (Digest)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAlgorithm());
            }
            $this$map$iv = DigestUtils.computeDigest$default(digestUtils, (List)destination$iv$iv, zipSections, 0, 4, null);
        }
        catch (DigestException e) {
            throw new ZipVerificationException("Failed to compute content digests: " + e.getMessage(), e);
        }
        List actualContentDigests = $this$map$iv;
        Iterable $this$forEach$iv = actualContentDigests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Digest expectedDigest;
            Object v0;
            Digest digest;
            block6: {
                digest = (Digest)element$iv;
                boolean bl = false;
                Iterable iterable = zipMetadata.getDigests();
                for (Object e : iterable) {
                    Digest it = (Digest)e;
                    boolean bl2 = false;
                    if (!(it.getAlgorithm() == digest.getAlgorithm())) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            if ((Digest)v0 == null) {
                throw new RuntimeException("Missing " + (Object)((Object)digest.getAlgorithm()) + " digest in metadata");
            }
            if (Arrays.equals(expectedDigest.getDigestBytes(), digest.getDigestBytes())) continue;
            throw new ZipVerificationException("ZIP integrity check failed. " + (Object)((Object)digest.getAlgorithm()) + "s digest mismatch.", null, 2, null);
        }
    }
}

