/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import java.util.Arrays;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.TextMateByteRange;
import org.jetbrains.plugins.textmate.regex.TextMateCharRange;
import org.jetbrains.plugins.textmate.regex.TextMateRangeKt;
import org.jetbrains.plugins.textmate.regex.TextMateString;

public final class MatchData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean matched;
    @NotNull
    private final int[] byteOffsets;
    @NotNull
    private static final MatchData NOT_MATCHED = new MatchData(false, new int[0]);

    public MatchData(boolean matched, @NotNull int[] byteOffsets) {
        Intrinsics.checkNotNullParameter((Object)byteOffsets, (String)"byteOffsets");
        this.matched = matched;
        this.byteOffsets = byteOffsets;
    }

    public final boolean getMatched() {
        return this.matched;
    }

    public final int count() {
        return this.byteOffsets.length / 2;
    }

    @NotNull
    public final TextMateByteRange byteRange(int group) {
        int endIndex = group * 2 + 1;
        return new TextMateByteRange(TextMateRangeKt.byteOffset(this.byteOffsets[endIndex - 1]), TextMateRangeKt.byteOffset(this.byteOffsets[endIndex]), null);
    }

    public static /* synthetic */ TextMateByteRange byteRange$default(MatchData matchData, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return matchData.byteRange(n);
    }

    @NotNull
    public final TextMateCharRange charRange(@NotNull TextMateString textMateString, int group) {
        Intrinsics.checkNotNullParameter((Object)textMateString, (String)"textMateString");
        return textMateString.charRangeByByteRange(this.byteRange(group));
    }

    public static /* synthetic */ TextMateCharRange charRange$default(MatchData matchData, TextMateString textMateString, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return matchData.charRange(textMateString, n);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        MatchData matchData = (MatchData)other;
        if (this.matched != matchData.matched) {
            return false;
        }
        return Arrays.equals(this.byteOffsets, matchData.byteOffsets);
    }

    public int hashCode() {
        return 31 * (this.matched ? 1 : 0) + Arrays.hashCode(this.byteOffsets);
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.byteOffsets);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "{ matched=" + this.matched + ", offsets=" + string + " }";
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MatchData getNOT_MATCHED() {
            return NOT_MATCHED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

