/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public final class TextMateSelectorLexer {
    @NotNull
    public static final TextMateSelectorLexer INSTANCE = new TextMateSelectorLexer();

    private TextMateSelectorLexer() {
    }

    @NotNull
    public final List<TextMateSelectorToken> tokenize(@NotNull CharSequence selector) {
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        List result2 = new ArrayList();
        StringBuilder currentSelector = new StringBuilder();
        for (int i2 = 0; i2 < selector.length(); ++i2) {
            char c = selector.charAt(i2);
            if (c == '(') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getLPAREN());
                continue;
            }
            if (c == ')') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getRPAREN());
                continue;
            }
            if (c == ',') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getCOMMA());
                continue;
            }
            if (c == '|') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getPIPE());
                continue;
            }
            if (c == '^') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getHAT());
                continue;
            }
            if (c == '-' && ((CharSequence)currentSelector).length() == 0) {
                currentSelector = this.addPendingToken(result2, currentSelector);
                result2.add(TextMateSelectorToken.Companion.getMINUS());
                continue;
            }
            if (c == ' ') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                continue;
            }
            if ((c == 'R' || c == 'L' || c == 'B') && i2 + 1 < selector.length() && selector.charAt(i2 + 1) == ':') {
                currentSelector = this.addPendingToken(result2, currentSelector);
                ++i2;
                switch (c) {
                    case 'R': {
                        result2.add(new TextMateSelectorToken.PriorityToken(TextMateWeigh.Priority.LOW));
                        break;
                    }
                    case 'L': {
                        result2.add(new TextMateSelectorToken.PriorityToken(TextMateWeigh.Priority.HIGH));
                    }
                }
                continue;
            }
            currentSelector.append(c);
        }
        this.addPendingToken(result2, currentSelector);
        return result2;
    }

    private final StringBuilder addPendingToken(List<TextMateSelectorToken> result2, StringBuilder currentSelector) {
        if (!(((CharSequence)currentSelector).length() == 0)) {
            String string = currentSelector.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result2.add(new TextMateSelectorToken.SelectorToken(string));
            return new StringBuilder();
        }
        return currentSelector;
    }
}

