/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateCapture;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextmateToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexUtilKt;
import org.jetbrains.plugins.textmate.regex.TextMateByteOffset;
import org.jetbrains.plugins.textmate.regex.TextMateByteRange;
import org.jetbrains.plugins.textmate.regex.TextMateCharOffset;
import org.jetbrains.plugins.textmate.regex.TextMateCharRange;
import org.jetbrains.plugins.textmate.regex.TextMateRangeKt;
import org.jetbrains.plugins.textmate.regex.TextMateString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextMateLexerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateLexerCore.kt\norg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerCore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
public final class TextMateLexerCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextMateLanguageDescriptor languageDescriptor;
    @NotNull
    private final TextMateSyntaxMatcher mySyntaxMatcher;
    private final int myLineLimit;
    private final boolean myStripWhitespaces;
    private int myCurrentOffset;
    @NotNull
    private CharSequence myText;
    @NotNull
    private TextMateScope myCurrentScope;
    @NotNull
    private ArrayDeque<Integer> myNestedScope;
    @NotNull
    private PersistentList<TextMateLexerState> myStates;

    public TextMateLexerCore(@NotNull TextMateLanguageDescriptor languageDescriptor, @NotNull TextMateSyntaxMatcher mySyntaxMatcher, int myLineLimit, boolean myStripWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)languageDescriptor, (String)"languageDescriptor");
        Intrinsics.checkNotNullParameter((Object)mySyntaxMatcher, (String)"mySyntaxMatcher");
        this.languageDescriptor = languageDescriptor;
        this.mySyntaxMatcher = mySyntaxMatcher;
        this.myLineLimit = myLineLimit;
        this.myStripWhitespaces = myStripWhitespaces;
        this.myCurrentOffset = TextMateRangeKt.charOffset(0);
        this.myText = "";
        this.myCurrentScope = TextMateScope.EMPTY;
        this.myNestedScope = new ArrayDeque();
        this.myStates = ExtensionsKt.persistentListOf();
    }

    public final int getCurrentOffset() {
        return this.myCurrentOffset;
    }

    public final void init(@NotNull CharSequence text2, int startCharOffset) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.init-Sp08x1s(text2, TextMateRangeKt.charOffset(startCharOffset));
    }

    /*
     * WARNING - void declaration
     */
    public final void init-Sp08x1s(@NotNull CharSequence text2, int n) {
        void it;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.myText = text2;
        this.myCurrentOffset = n;
        ArrayDeque arrayDeque = new ArrayDeque[]{TextMateLexerState.Companion.notMatched(this.languageDescriptor.getRootSyntaxNode())};
        this.myStates = ExtensionsKt.persistentListOf(arrayDeque);
        this.myCurrentScope = new TextMateScope(this.languageDescriptor.getRootScopeName(), null);
        ArrayDeque arrayDeque2 = arrayDeque = new ArrayDeque();
        TextMateLexerCore textMateLexerCore = this;
        boolean bl = false;
        it.addLast((Object)1);
        textMateLexerCore.myNestedScope = arrayDeque;
    }

    @NotNull
    public final List<TextmateToken> advanceLine(@Nullable Runnable checkCancelledCallback) {
        List list2;
        int startLineOffset = this.myCurrentOffset;
        int it = TextMateRangeKt.indexOf-AsUs2sA(this.myText, '\n', startLineOffset);
        boolean bl = false;
        int endLineOffset = it == -1 ? TextMateRangeKt.charOffset(this.myText.length()) : TextMateCharOffset.constructor-impl(it + 1);
        CharSequence lineCharSequence = TextMateRangeKt.subSequence-jM4F4xk(this.myText, startLineOffset, endLineOffset);
        if (this.myLineLimit >= 0 && lineCharSequence.length() > this.myLineLimit) {
            List output2 = new ArrayList();
            this.myStates = this.parseLine-pxcr4yw(lineCharSequence.subSequence(0, this.myLineLimit), output2, this.myStates, startLineOffset, TextMateRangeKt.charOffset(0), TextMateRangeKt.byteOffset(0), this.languageDescriptor.getInjections(), checkCancelledCallback);
            this.addToken-Sp08x1s(output2, endLineOffset);
            list2 = output2;
        } else {
            List output3 = new ArrayList();
            this.myStates = this.parseLine-pxcr4yw(lineCharSequence, output3, this.myStates, startLineOffset, TextMateRangeKt.charOffset(0), TextMateRangeKt.byteOffset(0), this.languageDescriptor.getInjections(), checkCancelledCallback);
            list2 = output3;
        }
        return list2;
    }

    private final PersistentList<TextMateLexerState> parseLine-pxcr4yw(CharSequence line, List<TextmateToken> output2, PersistentList<TextMateLexerState> states, int n, int n2, int n3, List<InjectionNodeDescriptor> injections, Runnable checkCancelledCallback) {
        Ref.ObjectRef states2 = new Ref.ObjectRef();
        states2.element = states;
        Ref.IntRef linePosition = new Ref.IntRef();
        linePosition.element = n2;
        Ref.IntRef lineByteOffset = new Ref.IntRef();
        lineByteOffset.element = n3;
        Ref.ObjectRef lastSuccessState = new Ref.ObjectRef();
        lastSuccessState.element = states2.element;
        Ref.IntRef lastSuccessStateOccursCount = new Ref.IntRef();
        Ref.IntRef lastMovedOffset = new Ref.IntRef();
        lastMovedOffset.element = n;
        boolean matchBeginString = n == 0 && linePosition.element == 0;
        Ref.IntRef anchorByteOffset = new Ref.IntRef();
        anchorByteOffset.element = TextMateRangeKt.byteOffset(-1);
        return (PersistentList)this.mySyntaxMatcher.matchingString(line, arg_0 -> TextMateLexerCore.parseLine_pxcr4yw$lambda$0(states2, this, lineByteOffset, anchorByteOffset, matchBeginString, checkCancelledCallback, output2, linePosition, n, injections, line, lastMovedOffset, lastSuccessState, lastSuccessStateOccursCount, arg_0));
    }

    private final boolean parseCaptures--NXEJUc(List<TextmateToken> output2, Constants.CaptureKey captureKey, SyntaxNodeDescriptor rule, MatchData matchData, TextMateString string, CharSequence line, int n, PersistentList<TextMateLexerState> states, Runnable checkCancelledCallback) {
        TextMateCapture[] textMateCaptureArray = rule.getCaptureRules(captureKey);
        if (textMateCaptureArray == null) {
            return false;
        }
        TextMateCapture[] captures = textMateCaptureArray;
        ArrayDeque activeCaptureRanges = new ArrayDeque();
        int n2 = matchData.count();
        for (int group = 0; group < n2; ++group) {
            TextMateByteRange byteRange;
            TextMateCapture capture;
            TextMateCapture textMateCapture = capture = group < captures.length ? captures[group] : null;
            if (capture == null || (byteRange = matchData.byteRange(group)).isEmpty()) continue;
            TextMateCharRange captureRange = matchData.charRange(string, group);
            while (!activeCaptureRanges.isEmpty() && TextMateCharOffset.compareTo-8igqF_k(((TextMateCharRange)activeCaptureRanges.last()).getEnd-PN4Uq9U(), captureRange.getStart-PN4Uq9U()) <= 0) {
                this.closeScopeSelector-Sp08x1s(output2, TextMateCharOffset.plus-FGq031g(n, ((TextMateCharRange)activeCaptureRanges.removeLast()).getEnd-PN4Uq9U()));
            }
            if (capture instanceof TextMateCapture.Name) {
                int selectorStartOffset;
                CharSequence captureName = ((TextMateCapture.Name)capture).getName();
                CharSequence scopeName = rule.hasBackReference(captureKey, group) ? SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInCaptures(captureName, string, matchData) : captureName;
                int indexOfSpace = TextMateRangeKt.indexOf-AsUs2sA(scopeName, ' ', selectorStartOffset = TextMateRangeKt.charOffset(0));
                if (indexOfSpace == -1) {
                    this.openScopeSelector-AsUs2sA(output2, scopeName, TextMateCharOffset.plus-FGq031g(n, captureRange.getStart-PN4Uq9U()));
                    activeCaptureRanges.addLast((Object)captureRange);
                    continue;
                }
                while (indexOfSpace >= 0) {
                    this.openScopeSelector-AsUs2sA(output2, TextMateRangeKt.subSequence-jM4F4xk(scopeName, selectorStartOffset, indexOfSpace), TextMateCharOffset.plus-FGq031g(n, captureRange.getStart-PN4Uq9U()));
                    selectorStartOffset = TextMateCharOffset.constructor-impl(indexOfSpace + 1);
                    indexOfSpace = TextMateRangeKt.indexOf-AsUs2sA(scopeName, ' ', selectorStartOffset);
                    activeCaptureRanges.addLast((Object)captureRange);
                }
                this.openScopeSelector-AsUs2sA(output2, TextMateRangeKt.subSequence-jM4F4xk(scopeName, selectorStartOffset, TextMateRangeKt.charOffset(scopeName.length())), TextMateCharOffset.plus-FGq031g(n, captureRange.getStart-PN4Uq9U()));
                activeCaptureRanges.addLast((Object)captureRange);
                continue;
            }
            if (capture instanceof TextMateCapture.Rule) {
                CharSequence capturedString = TextMateRangeKt.subSequence-jM4F4xk(line, TextMateRangeKt.charOffset(0), captureRange.getEnd-PN4Uq9U());
                this.mySyntaxMatcher.matchingString(capturedString, arg_0 -> TextMateLexerCore.parseCaptures__NXEJUc$lambda$0(capture, matchData, byteRange, this, capturedString, output2, states, n, captureRange, checkCancelledCallback, arg_0));
                continue;
            }
            throw new IllegalStateException(("unknown capture type: " + capture).toString());
        }
        while (!activeCaptureRanges.isEmpty()) {
            this.closeScopeSelector-Sp08x1s(output2, TextMateCharOffset.plus-FGq031g(n, ((TextMateCharRange)activeCaptureRanges.removeLast()).getEnd-PN4Uq9U()));
        }
        return true;
    }

    private final void openScopeSelector-AsUs2sA(List<TextmateToken> output2, CharSequence name2, int n) {
        this.addToken-Sp08x1s(output2, n);
        int count = 0;
        int prevIndexOfSpace = 0;
        if (name2 != null) {
            int indexOfSpace = StringsKt.indexOf((CharSequence)name2, (char)' ', (int)0, (boolean)false);
            while (indexOfSpace >= 0) {
                this.myCurrentScope = this.myCurrentScope.add(name2.subSequence(prevIndexOfSpace, indexOfSpace));
                prevIndexOfSpace = indexOfSpace + 1;
                indexOfSpace = StringsKt.indexOf((CharSequence)name2, (char)' ', (int)prevIndexOfSpace, (boolean)false);
                ++count;
            }
        }
        CharSequence charSequence = name2;
        this.myCurrentScope = this.myCurrentScope.add(charSequence != null ? charSequence.subSequence(prevIndexOfSpace, name2.length()) : null);
        this.myNestedScope.addLast((Object)(count + 1));
    }

    private final void closeScopeSelector-Sp08x1s(List<TextmateToken> output2, int n) {
        block3: {
            CharSequence lastOpenedName = this.myCurrentScope.getScopeName();
            if (lastOpenedName != null && !(lastOpenedName.length() == 0)) {
                this.addToken-Sp08x1s(output2, n);
            }
            Integer n2 = (Integer)this.myNestedScope.removeLastOrNull();
            if (n2 == null) break block3;
            int nestingLevel = ((Number)n2).intValue();
            boolean bl = false;
            for (int j = 0; j < nestingLevel; ++j) {
                int it = j;
                boolean bl2 = false;
                TextMateScope textMateScope = this.myCurrentScope.getParent();
                if (textMateScope == null) {
                    textMateScope = this.myCurrentScope;
                }
                this.myCurrentScope = textMateScope;
            }
        }
    }

    private final void addToken-Sp08x1s(List<TextmateToken> output2, int n) {
        int position = TextMateRangeKt.charOffset(Math.min(n, this.myText.length()));
        if (TextMateCharOffset.compareTo-8igqF_k(position, this.myCurrentOffset) > 0) {
            boolean restartable2 = this.myCurrentScope.getParent() == null;
            int wsStart = this.myCurrentOffset;
            while (this.myStripWhitespaces && TextMateCharOffset.compareTo-8igqF_k(position, this.myCurrentOffset) > 0 && CharsKt.isWhitespace((char)TextMateRangeKt.get-Sp08x1s(this.myText, this.myCurrentOffset))) {
                this.myCurrentOffset = TextMateCharOffset.constructor-impl(this.myCurrentOffset + 1);
            }
            if (TextMateCharOffset.compareTo-8igqF_k(wsStart, this.myCurrentOffset) < 0) {
                output2.add(new TextmateToken(TextMateScope.WHITESPACE, wsStart, this.myCurrentOffset, restartable2, null));
                restartable2 = false;
            }
            int wsEnd = position;
            while (this.myStripWhitespaces && TextMateCharOffset.compareTo-8igqF_k(wsEnd, this.myCurrentOffset) > 0 && CharsKt.isWhitespace((char)this.myText.charAt(wsEnd - 1))) {
                wsEnd = TextMateCharOffset.constructor-impl(wsEnd - 1);
            }
            if (TextMateCharOffset.compareTo-8igqF_k(this.myCurrentOffset, wsEnd) < 0) {
                output2.add(new TextmateToken(this.myCurrentScope, this.myCurrentOffset, wsEnd, restartable2, null));
            }
            if (TextMateCharOffset.compareTo-8igqF_k(wsEnd, position) < 0) {
                output2.add(new TextmateToken(TextMateScope.WHITESPACE, wsEnd, position, restartable2, null));
            }
            this.myCurrentOffset = position;
        }
    }

    private static final PersistentList parseLine_pxcr4yw$lambda$0(Ref.ObjectRef $states, TextMateLexerCore this$0, Ref.IntRef $lineByteOffset, Ref.IntRef $anchorByteOffset, boolean $matchBeginString, Runnable $checkCancelledCallback, List $output, Ref.IntRef $linePosition, int n, List $injections, CharSequence $line, Ref.IntRef $lastMovedOffset, Ref.ObjectRef $lastSuccessState, Ref.IntRef $lastSuccessStateOccursCount, TextMateString string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        PersistentList whileStates = (PersistentList)$states.element;
        while (!whileStates.isEmpty()) {
            TextMateLexerState whileState = (TextMateLexerState)CollectionsKt.last((List)whileStates);
            whileStates = whileStates.removeAt(whileStates.size() - 1);
            if (whileState.getSyntaxRule().getStringAttribute(Constants.StringKey.WHILE) == null) continue;
            MatchData matchWhile = this$0.mySyntaxMatcher.matchStringRegex-pFV-0G8(Constants.StringKey.WHILE, string, $lineByteOffset.element, TextMateByteOffset.equals-impl0($anchorByteOffset.element, $lineByteOffset.element), $matchBeginString, whileState, $checkCancelledCallback);
            if (matchWhile.getMatched()) {
                if ($anchorByteOffset.element != -1) continue;
                $anchorByteOffset.element = MatchData.byteRange$default(matchWhile, 0, 1, null).getEnd-Esigj34();
                continue;
            }
            this$0.closeScopeSelector-Sp08x1s($output, TextMateCharOffset.plus-FGq031g($linePosition.element, n));
            this$0.closeScopeSelector-Sp08x1s($output, TextMateCharOffset.plus-FGq031g($linePosition.element, n));
            $states.element = whileStates;
            $anchorByteOffset.element = TextMateRangeKt.byteOffset(-1);
        }
        Set localStates = new LinkedHashSet();
        while (true) {
            TextMateLexerState lastState = (TextMateLexerState)CollectionsKt.last((List)((List)$states.element));
            SyntaxNodeDescriptor lastRule = lastState.getSyntaxRule();
            TextMateLexerState currentState = this$0.mySyntaxMatcher.matchRule-4maaBYg(lastRule, string, $lineByteOffset.element, TextMateByteOffset.equals-impl0($anchorByteOffset.element, $lineByteOffset.element), $matchBeginString, TextMateWeigh.Priority.NORMAL, this$0.myCurrentScope, $injections, $checkCancelledCallback);
            SyntaxNodeDescriptor currentRule = currentState.getSyntaxRule();
            MatchData currentMatch = currentState.getMatchData();
            int endPosition = 0;
            MatchData endMatch = this$0.mySyntaxMatcher.matchStringRegex-pFV-0G8(Constants.StringKey.END, string, $lineByteOffset.element, TextMateByteOffset.equals-impl0($anchorByteOffset.element, $lineByteOffset.element), $matchBeginString, lastState, $checkCancelledCallback);
            int lineLength = TextMateRangeKt.charOffset($line.length());
            if (endMatch.getMatched() && (!currentMatch.getMatched() || TextMateByteOffset.compareTo-3kD0su4(MatchData.byteRange$default(currentMatch, 0, 1, null).getStart-Esigj34(), MatchData.byteRange$default(endMatch, 0, 1, null).getStart-Esigj34()) >= 0 || Intrinsics.areEqual((Object)lastState, (Object)currentState))) {
                TextMateLexerState poppedState = (TextMateLexerState)CollectionsKt.last((List)((List)$states.element));
                if (poppedState.getMatchData().getMatched() && !poppedState.getMatchedEOL()) {
                    $anchorByteOffset.element = MatchData.byteRange$default(poppedState.getMatchData(), 0, 1, null).getEnd-Esigj34();
                }
                $states.element = ((PersistentList)$states.element).removeAt(((PersistentList)$states.element).size() - 1);
                TextMateCharRange endRange = MatchData.charRange$default(endMatch, string, 0, 2, null);
                int startPosition = endPosition = endRange.getStart-PN4Uq9U();
                this$0.closeScopeSelector-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(startPosition, n));
                if (lastRule.getCaptureRules(Constants.CaptureKey.END_CAPTURES) == null && lastRule.getCaptureRules(Constants.CaptureKey.CAPTURES) == null || this$0.parseCaptures--NXEJUc($output, Constants.CaptureKey.END_CAPTURES, lastRule, endMatch, string, $line, n, (PersistentList)$states.element, $checkCancelledCallback) || this$0.parseCaptures--NXEJUc($output, Constants.CaptureKey.CAPTURES, lastRule, endMatch, string, $line, n, (PersistentList)$states.element, $checkCancelledCallback)) {
                    endPosition = endRange.getEnd-PN4Uq9U();
                }
                this$0.closeScopeSelector-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(endPosition, n));
                if (TextMateCharOffset.equals-impl0($linePosition.element, endPosition) && TextMateLexerCore.Companion.containsLexerState(localStates, poppedState) && TextMateByteOffset.equals-impl0(poppedState.getEnterByteOffset-Esigj34(), $lineByteOffset.element)) {
                    this$0.addToken-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(lineLength, n));
                    break;
                }
                v0 = localStates.remove(poppedState);
            } else if (currentMatch.getMatched()) {
                $anchorByteOffset.element = MatchData.byteRange$default(currentMatch, 0, 1, null).getEnd-Esigj34();
                TextMateCharRange currentRange = MatchData.charRange$default(currentMatch, string, 0, 2, null);
                int startPosition = currentRange.getStart-PN4Uq9U();
                endPosition = currentRange.getEnd-PN4Uq9U();
                if (currentRule.getStringAttribute(Constants.StringKey.BEGIN) != null) {
                    $states.element = ((PersistentList)$states.element).add(currentState);
                    CharSequence name2 = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this$0.openScopeSelector-AsUs2sA($output, name2, TextMateCharOffset.plus-FGq031g(startPosition, n));
                    this$0.parseCaptures--NXEJUc($output, Constants.CaptureKey.BEGIN_CAPTURES, currentRule, currentMatch, string, $line, n, (PersistentList)$states.element, $checkCancelledCallback);
                    this$0.parseCaptures--NXEJUc($output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, $line, n, (PersistentList)$states.element, $checkCancelledCallback);
                    CharSequence contentName = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.CONTENT_NAME, currentRule, string, currentMatch);
                    this$0.openScopeSelector-AsUs2sA($output, contentName, TextMateCharOffset.plus-FGq031g(endPosition, n));
                } else if (currentRule.getStringAttribute(Constants.StringKey.MATCH) != null) {
                    CharSequence name3 = TextMateLexerCore.Companion.getStringAttribute(Constants.StringKey.NAME, currentRule, string, currentMatch);
                    this$0.openScopeSelector-AsUs2sA($output, name3, TextMateCharOffset.plus-FGq031g(startPosition, n));
                    this$0.parseCaptures--NXEJUc($output, Constants.CaptureKey.CAPTURES, currentRule, currentMatch, string, $line, n, (PersistentList)$states.element, $checkCancelledCallback);
                    this$0.closeScopeSelector-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(endPosition, n));
                }
                if (TextMateCharOffset.equals-impl0($linePosition.element, endPosition) && TextMateLexerCore.Companion.containsLexerState(localStates, currentState)) {
                    this$0.addToken-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(lineLength, n));
                    break;
                }
                v0 = localStates.add(currentState);
            } else {
                this$0.addToken-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(lineLength, n));
                break;
            }
            if (TextMateCharOffset.compareTo-8igqF_k($lastMovedOffset.element, this$0.myCurrentOffset) < 0) {
                $lastSuccessState.element = $states.element;
                $lastSuccessStateOccursCount.element = 0;
                $lastMovedOffset.element = this$0.myCurrentOffset;
            } else if (Intrinsics.areEqual((Object)$lastSuccessState.element, (Object)$states.element)) {
                if ($lastSuccessStateOccursCount.element > 10) {
                    this$0.addToken-Sp08x1s($output, TextMateCharOffset.plus-FGq031g(lineLength, n));
                    break;
                }
                int n2 = $lastSuccessStateOccursCount.element;
                $lastSuccessStateOccursCount.element = n2 + 1;
            }
            if (!TextMateCharOffset.equals-impl0($linePosition.element, endPosition)) {
                $lineByteOffset.element = TextMateByteOffset.plus-URtGV2I($lineByteOffset.element, RegexUtilKt.byteOffsetByCharOffset-jM4F4xk($line, $linePosition.element, endPosition));
                $linePosition.element = endPosition;
            }
            Runnable runnable2 = $checkCancelledCallback;
            if (runnable2 == null) continue;
            runnable2.run();
        }
        return (PersistentList)$states.element;
    }

    private static final PersistentList parseCaptures__NXEJUc$lambda$0(TextMateCapture $capture, MatchData $matchData, TextMateByteRange $byteRange, TextMateLexerCore this$0, CharSequence $capturedString, List $output, PersistentList $states, int n, TextMateCharRange $captureRange, Runnable $checkCancelledCallback, TextMateString capturedTextMateString) {
        Intrinsics.checkNotNullParameter((Object)capturedTextMateString, (String)"capturedTextMateString");
        TextMateLexerState captureState = new TextMateLexerState(((TextMateCapture.Rule)$capture).getNode(), $matchData, TextMateWeigh.Priority.NORMAL, $byteRange.getStart-Esigj34(), capturedTextMateString, null);
        return this$0.parseLine-pxcr4yw($capturedString, $output, $states.add(captureState), n, $captureRange.getStart-PN4Uq9U(), $byteRange.getStart-Esigj34(), CollectionsKt.emptyList(), $checkCancelledCallback);
    }

    public static final class Companion {
        private Companion() {
        }

        private final boolean containsLexerState(Set<TextMateLexerState> states, TextMateLexerState state2) {
            for (TextMateLexerState s : states) {
                if (!TextMateByteOffset.equals-impl0(s.getEnterByteOffset-Esigj34(), state2.getEnterByteOffset-Esigj34()) || !Intrinsics.areEqual((Object)s.getSyntaxRule(), (Object)state2.getSyntaxRule())) continue;
                return true;
            }
            return false;
        }

        private final CharSequence getStringAttribute(Constants.StringKey keyName, SyntaxNodeDescriptor syntaxRule, TextMateString string, MatchData matchData) {
            CharSequence stringAttribute = syntaxRule.getStringAttribute(keyName);
            return stringAttribute == null ? null : (syntaxRule.hasBackReference(keyName) ? SyntaxMatchUtils.INSTANCE.replaceGroupsWithMatchDataInCaptures(stringAttribute, string, matchData) : stringAttribute);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

