/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Locale;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.TextMateByteRange;
import org.jetbrains.plugins.textmate.regex.TextMateString;

public final class SyntaxMatchUtils {
    @NotNull
    public static final SyntaxMatchUtils INSTANCE = new SyntaxMatchUtils();
    @NotNull
    private static final Regex BACK_REFERENCE_REPLACEMENT_REGEX = new Regex("[\\-\\\\{}*+?|^$.,\\[\\]()#\\s]");
    @NotNull
    private static final Regex CAPTURE_GROUP_REGEX = new Regex("\\$([0-9]+)|\\$\\{([0-9]+):/(downcase|upcase)}");

    private SyntaxMatchUtils() {
    }

    @NotNull
    public final String replaceGroupsWithMatchDataInRegex(@NotNull CharSequence string, @Nullable TextMateString matchingString, @NotNull MatchData matchData) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)matchData, (String)"matchData");
        if (matchingString == null || !matchData.getMatched()) {
            return ((Object)string).toString();
        }
        StringBuilder $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int charIndex = 0;
        int length = string.length();
        while (charIndex < length) {
            char c = string.charAt(charIndex);
            if (c == '\\') {
                int digitIndex;
                boolean hasGroupIndex = false;
                int groupIndex = 0;
                for (digitIndex = charIndex + 1; digitIndex < length; ++digitIndex) {
                    int digit;
                    Integer n = CharsKt.digitToIntOrNull((char)string.charAt(digitIndex));
                    int n2 = digit = n != null ? n : -1;
                    if (digit == -1) break;
                    hasGroupIndex = true;
                    groupIndex = groupIndex * 10 + digit;
                }
                if (hasGroupIndex && matchData.count() > groupIndex) {
                    TextMateByteRange byteRange = matchData.byteRange(groupIndex);
                    String replacement = byteRange.isEmpty() ? "" : ((Object)matchingString.subSequenceByByteRange(byteRange)).toString();
                    $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240.append(BACK_REFERENCE_REPLACEMENT_REGEX.replace((CharSequence)replacement, "\\\\$0"));
                    charIndex = digitIndex;
                    continue;
                }
            }
            $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240.append(c);
            ++charIndex;
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final CharSequence replaceGroupsWithMatchDataInCaptures(@NotNull CharSequence string, @NotNull TextMateString matchingString, @NotNull MatchData matchData) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)matchingString, (String)"matchingString");
        Intrinsics.checkNotNullParameter((Object)matchData, (String)"matchData");
        if (!matchData.getMatched()) {
            return string;
        }
        MatchResult matcher = null;
        StringBuilder $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int lastPosition = 0;
        for (matcher = Regex.find$default((Regex)CAPTURE_GROUP_REGEX, (CharSequence)string, (int)0, (int)2, null); matcher != null; matcher = matcher.next()) {
            String command2;
            int groupIndex;
            Object object;
            Object object2 = matcher.getGroups().get(1);
            if (object2 == null) {
                object2 = object = matcher.getGroups().get(2);
            }
            int n = object2 != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (groupIndex = -1);
            if (groupIndex < 0 || matchData.count() <= groupIndex) continue;
            $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240.append(string, lastPosition, matcher.getRange().getFirst());
            TextMateByteRange byteRange = matchData.byteRange(groupIndex);
            String capturedText = byteRange.isEmpty() ? "" : ((Object)matchingString.subSequenceByByteRange(byteRange)).toString();
            char[] cArray = new char[]{'.'};
            String replacement = StringsKt.trimStart((String)capturedText, (char[])cArray);
            MatchGroup matchGroup = matcher.getGroups().get(3);
            String string2 = command2 = matchGroup != null ? matchGroup.getValue() : null;
            if (Intrinsics.areEqual((Object)string2, (Object)"downcase")) {
                String string3 = replacement.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240.append(string3);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"upcase")) {
                String string4 = replacement.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240.append(string4);
            } else {
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240.append(replacement);
            }
            lastPosition = matcher.getRange().getLast() + 1;
        }
        if (lastPosition < string.length()) {
            $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u240.append(string.subSequence(lastPosition, string.length()));
        }
        return stringBuilder.toString();
    }
}

