/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.TeamCityCheckAttempt;
import org.jetbrains.patronus.client.model.TeamCityCheckStatus;

public final class TeamCityCheck {
    @NotNull
    private final UUID id;
    @Nullable
    private final String name;
    @NotNull
    private final String buildConfigurationId;
    @NotNull
    private final String buildConfigurationName;
    @NotNull
    private final String buildConfigurationProjectName;
    @NotNull
    private final String buildConfigurationUrl;
    @NotNull
    private final TeamCityCheckStatus status;
    @Nullable
    private final Instant queuedAt;
    @Nullable
    private final Instant startedAt;
    @Nullable
    private final Instant finishedAt;
    @Nullable
    private final Integer queuePosition;
    @Nullable
    private final String skipReason;
    private final int attemptLimit;
    @NotNull
    private final List<TeamCityCheckAttempt> attempts;

    public TeamCityCheck(@NotNull UUID id, @Nullable String name2, @NotNull String buildConfigurationId, @NotNull String buildConfigurationName, @NotNull String buildConfigurationProjectName, @NotNull String buildConfigurationUrl, @NotNull TeamCityCheckStatus status2, @Nullable Instant queuedAt, @Nullable Instant startedAt, @Nullable Instant finishedAt, @Nullable Integer queuePosition, @Nullable String skipReason, int attemptLimit, @NotNull List<TeamCityCheckAttempt> attempts) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationId, (String)"buildConfigurationId");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationName, (String)"buildConfigurationName");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationProjectName, (String)"buildConfigurationProjectName");
        Intrinsics.checkNotNullParameter((Object)buildConfigurationUrl, (String)"buildConfigurationUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Intrinsics.checkNotNullParameter(attempts, (String)"attempts");
        this.id = id;
        this.name = name2;
        this.buildConfigurationId = buildConfigurationId;
        this.buildConfigurationName = buildConfigurationName;
        this.buildConfigurationProjectName = buildConfigurationProjectName;
        this.buildConfigurationUrl = buildConfigurationUrl;
        this.status = status2;
        this.queuedAt = queuedAt;
        this.startedAt = startedAt;
        this.finishedAt = finishedAt;
        this.queuePosition = queuePosition;
        this.skipReason = skipReason;
        this.attemptLimit = attemptLimit;
        this.attempts = attempts;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getBuildConfigurationUrl() {
        return this.buildConfigurationUrl;
    }

    @NotNull
    public final TeamCityCheckStatus getStatus() {
        return this.status;
    }

    @Nullable
    public final Instant getQueuedAt() {
        return this.queuedAt;
    }

    @Nullable
    public final Instant getStartedAt() {
        return this.startedAt;
    }

    @Nullable
    public final Instant getFinishedAt() {
        return this.finishedAt;
    }

    @Nullable
    public final Integer getQueuePosition() {
        return this.queuePosition;
    }

    @Nullable
    public final String getSkipReason() {
        return this.skipReason;
    }

    public final int getAttemptLimit() {
        return this.attemptLimit;
    }

    @NotNull
    public final List<TeamCityCheckAttempt> getAttempts() {
        return this.attempts;
    }

    @NotNull
    public String toString() {
        return "TeamCityCheck(id=" + this.id + ", name=" + this.name + ", buildConfigurationId=" + this.buildConfigurationId + ", buildConfigurationName=" + this.buildConfigurationName + ", buildConfigurationProjectName=" + this.buildConfigurationProjectName + ", buildConfigurationUrl=" + this.buildConfigurationUrl + ", status=" + this.status + ", queuedAt=" + this.queuedAt + ", startedAt=" + this.startedAt + ", finishedAt=" + this.finishedAt + ", queuePosition=" + this.queuePosition + ", skipReason=" + this.skipReason + ", attemptLimit=" + this.attemptLimit + ", attempts=" + this.attempts + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        result2 = result2 * 31 + this.buildConfigurationId.hashCode();
        result2 = result2 * 31 + this.buildConfigurationName.hashCode();
        result2 = result2 * 31 + this.buildConfigurationProjectName.hashCode();
        result2 = result2 * 31 + this.buildConfigurationUrl.hashCode();
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.queuedAt == null ? 0 : this.queuedAt.hashCode());
        result2 = result2 * 31 + (this.startedAt == null ? 0 : this.startedAt.hashCode());
        result2 = result2 * 31 + (this.finishedAt == null ? 0 : this.finishedAt.hashCode());
        result2 = result2 * 31 + (this.queuePosition == null ? 0 : ((Object)this.queuePosition).hashCode());
        result2 = result2 * 31 + (this.skipReason == null ? 0 : this.skipReason.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.attemptLimit);
        result2 = result2 * 31 + ((Object)this.attempts).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TeamCityCheck)) {
            return false;
        }
        TeamCityCheck teamCityCheck = (TeamCityCheck)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)teamCityCheck.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)teamCityCheck.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationId, (Object)teamCityCheck.buildConfigurationId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationName, (Object)teamCityCheck.buildConfigurationName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationProjectName, (Object)teamCityCheck.buildConfigurationProjectName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildConfigurationUrl, (Object)teamCityCheck.buildConfigurationUrl)) {
            return false;
        }
        if (this.status != teamCityCheck.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.queuedAt, (Object)teamCityCheck.queuedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startedAt, (Object)teamCityCheck.startedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.finishedAt, (Object)teamCityCheck.finishedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.queuePosition, (Object)teamCityCheck.queuePosition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.skipReason, (Object)teamCityCheck.skipReason)) {
            return false;
        }
        if (this.attemptLimit != teamCityCheck.attemptLimit) {
            return false;
        }
        return Intrinsics.areEqual(this.attempts, teamCityCheck.attempts);
    }
}

