/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.Principal;
import org.jetbrains.patronus.client.model.PushMode;
import org.jetbrains.patronus.client.model.RobotStatus;
import org.jetbrains.patronus.client.model.RobotType;

public final class Robot {
    @NotNull
    private final String name;
    @NotNull
    private final UUID id;
    @NotNull
    private final PushMode pushMode;
    @NotNull
    private final RobotType type;
    @NotNull
    private final String repository;
    @Nullable
    private final String sourceBranch;
    @NotNull
    private final String targetBranch;
    @NotNull
    private final Instant startDateTime;
    @Nullable
    private final Instant finishDateTime;
    @NotNull
    private final RobotStatus status;
    @Nullable
    private final String cancellationReason;
    @NotNull
    private final Principal owner;
    @Nullable
    private final String spaceReviewKey;
    @Nullable
    private final String spaceReviewUrl;
    private final boolean isEmergency;

    public Robot(@NotNull String name2, @NotNull UUID id, @NotNull PushMode pushMode, @NotNull RobotType type2, @NotNull String repository, @Nullable String sourceBranch, @NotNull String targetBranch, @NotNull Instant startDateTime, @Nullable Instant finishDateTime, @NotNull RobotStatus status2, @Nullable String cancellationReason, @NotNull Principal owner2, @Nullable String spaceReviewKey, @Nullable String spaceReviewUrl, boolean isEmergency) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)pushMode), (String)"pushMode");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)targetBranch, (String)"targetBranch");
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        Intrinsics.checkNotNullParameter((Object)owner2, (String)"owner");
        this.name = name2;
        this.id = id;
        this.pushMode = pushMode;
        this.type = type2;
        this.repository = repository;
        this.sourceBranch = sourceBranch;
        this.targetBranch = targetBranch;
        this.startDateTime = startDateTime;
        this.finishDateTime = finishDateTime;
        this.status = status2;
        this.cancellationReason = cancellationReason;
        this.owner = owner2;
        this.spaceReviewKey = spaceReviewKey;
        this.spaceReviewUrl = spaceReviewUrl;
        this.isEmergency = isEmergency;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public final String getRepository() {
        return this.repository;
    }

    @Nullable
    public final String getSourceBranch() {
        return this.sourceBranch;
    }

    @NotNull
    public final String getTargetBranch() {
        return this.targetBranch;
    }

    @NotNull
    public final Instant getStartDateTime() {
        return this.startDateTime;
    }

    @Nullable
    public final Instant getFinishDateTime() {
        return this.finishDateTime;
    }

    @NotNull
    public final RobotStatus getStatus() {
        return this.status;
    }

    @NotNull
    public String toString() {
        return "Robot(name=" + this.name + ", id=" + this.id + ", pushMode=" + this.pushMode + ", type=" + this.type + ", repository=" + this.repository + ", sourceBranch=" + this.sourceBranch + ", targetBranch=" + this.targetBranch + ", startDateTime=" + this.startDateTime + ", finishDateTime=" + this.finishDateTime + ", status=" + this.status + ", cancellationReason=" + this.cancellationReason + ", owner=" + this.owner + ", spaceReviewKey=" + this.spaceReviewKey + ", spaceReviewUrl=" + this.spaceReviewUrl + ", isEmergency=" + this.isEmergency + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.pushMode.hashCode();
        result2 = result2 * 31 + this.type.hashCode();
        result2 = result2 * 31 + this.repository.hashCode();
        result2 = result2 * 31 + (this.sourceBranch == null ? 0 : this.sourceBranch.hashCode());
        result2 = result2 * 31 + this.targetBranch.hashCode();
        result2 = result2 * 31 + this.startDateTime.hashCode();
        result2 = result2 * 31 + (this.finishDateTime == null ? 0 : this.finishDateTime.hashCode());
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.cancellationReason == null ? 0 : this.cancellationReason.hashCode());
        result2 = result2 * 31 + this.owner.hashCode();
        result2 = result2 * 31 + (this.spaceReviewKey == null ? 0 : this.spaceReviewKey.hashCode());
        result2 = result2 * 31 + (this.spaceReviewUrl == null ? 0 : this.spaceReviewUrl.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.isEmergency);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Robot)) {
            return false;
        }
        Robot robot = (Robot)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)robot.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)robot.id)) {
            return false;
        }
        if (this.pushMode != robot.pushMode) {
            return false;
        }
        if (this.type != robot.type) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.repository, (Object)robot.repository)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceBranch, (Object)robot.sourceBranch)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetBranch, (Object)robot.targetBranch)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDateTime, (Object)robot.startDateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.finishDateTime, (Object)robot.finishDateTime)) {
            return false;
        }
        if (this.status != robot.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cancellationReason, (Object)robot.cancellationReason)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.owner, (Object)robot.owner)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spaceReviewKey, (Object)robot.spaceReviewKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spaceReviewUrl, (Object)robot.spaceReviewUrl)) {
            return false;
        }
        return this.isEmergency == robot.isEmergency;
    }
}

