/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.mac.CoreFoundationExt;
import org.jetbrains.nativecerts.mac.CoreFoundationExtUtil;
import org.jetbrains.nativecerts.mac.SecurityFramework;

public class SecurityFrameworkUtil {
    private static final Logger LOGGER = Logger.getLogger(SecurityFrameworkUtil.class.getName());

    private SecurityFrameworkUtil() {
    }

    public static List<X509Certificate> getTrustedRoots() {
        return SecurityFrameworkUtil.getTrustedRoots(false);
    }

    private static List<X509Certificate> getTrustedRoots(boolean systemDomain) {
        List<X509Certificate> result2 = SecurityFrameworkUtil.getTrustedCertificates(systemDomain);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message2 = new StringBuilder();
            message2.append("Received ").append(result2.size()).append(" certificates");
            if (systemDomain) {
                message2.append(" from the system keychain");
            }
            for (X509Certificate certificate2 : result2) {
                message2.append("\n  ").append(certificate2.getSubjectX500Principal());
            }
            LOGGER.fine(message2.toString());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<X509Certificate> getTrustedCertificates(boolean systemDomain) {
        CoreFoundationExt.CFArrayRefByReference returnedCertArray = new CoreFoundationExt.CFArrayRefByReference();
        SecurityFramework.SecKeychainRefByReference keychain = new SecurityFramework.SecKeychainRefByReference();
        CoreFoundation.CFArrayRef searchDomainList = null;
        CoreFoundation.CFArrayRef certArray = null;
        CoreFoundation.CFDictionaryRef query2 = null;
        try {
            SecurityFramework.OSStatus rc;
            HashMap<CoreFoundation.CFTypeRef, CoreFoundation.CFTypeRef> map2 = new HashMap<CoreFoundation.CFTypeRef, CoreFoundation.CFTypeRef>();
            map2.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecClass, (CoreFoundation.CFTypeRef)SecurityFramework.kSecClassCertificate);
            map2.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchLimit, (CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchLimitAll);
            map2.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecReturnRef, (CoreFoundation.CFTypeRef)CoreFoundationExt.kCFBooleanTrue);
            if (systemDomain) {
                rc = SecurityFramework.INSTANCE.SecKeychainOpen("/System/Library/Keychains/SystemRootCertificates.keychain", keychain);
                if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                    throw new IllegalStateException("Failed to read system keychain: " + String.valueOf((Object)rc));
                }
                searchDomainList = CoreFoundation.INSTANCE.CFArrayCreate(null, keychain.getPointer(), new CoreFoundation.CFIndex(1L), null);
                map2.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchSearchList, (CoreFoundation.CFTypeRef)searchDomainList);
            }
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)(rc = SecurityFramework.INSTANCE.SecItemCopyMatching(query2 = CoreFoundationExtUtil.createDictionary(map2), returnedCertArray)))) {
                throw new IllegalStateException("SecItemCopyMatching failed: " + String.valueOf((Object)rc));
            }
            certArray = returnedCertArray.getArray();
            if (certArray == null) {
                List<X509Certificate> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<X509Certificate> result2 = new ArrayList<X509Certificate>();
            for (int i2 = 0; i2 < certArray.getCount(); ++i2) {
                String certificateDescription;
                SecurityFramework.SecCertificateRef secCertificateRef;
                block19: {
                    secCertificateRef = new SecurityFramework.SecCertificateRef(certArray.getValueAtIndex(i2));
                    if (!systemDomain) {
                        try {
                            boolean trustedRoot = SecurityFrameworkUtil.isTrustedRoot(secCertificateRef);
                            if (!trustedRoot) {
                                certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                                LOGGER.fine("Certificate '" + certificateDescription + "' has failed to validate against trusted roots");
                            }
                            break block19;
                        }
                        catch (Throwable validateException) {
                            certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                            LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to check certificate '" + certificateDescription + "'", validateException));
                        }
                        continue;
                    }
                }
                try {
                    result2.add(SecurityFrameworkUtil.getX509Certificate(secCertificateRef));
                    continue;
                }
                catch (Throwable parsingError) {
                    certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate '" + certificateDescription + "'", parsingError));
                }
            }
            ArrayList<X509Certificate> arrayList = result2;
            return arrayList;
        }
        finally {
            SecurityFramework.SecKeychainRef secKeychainRef;
            if (query2 != null) {
                query2.release();
            }
            if (certArray != null) {
                certArray.release();
            }
            if (searchDomainList != null) {
                searchDomainList.release();
            }
            if ((secKeychainRef = keychain.getSecKeychainRef()) != null) {
                secKeychainRef.release();
            }
        }
    }

    private static X509Certificate getX509Certificate(SecurityFramework.SecCertificateRef secCertificateRef) {
        CoreFoundation.CFDataRef data2 = SecurityFramework.INSTANCE.SecCertificateCopyData(secCertificateRef);
        try {
            byte[] bytes2 = data2.getBytePtr().getByteArray(0L, data2.getLength());
            X509Certificate x509Certificate = NativeTrustedRootsInternalUtils.parseCertificate(bytes2);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            data2.release();
        }
    }

    static boolean isSelfSignedCertificate(X509Certificate certificate2) {
        if (!certificate2.getSubjectX500Principal().equals(certificate2.getIssuerX500Principal())) {
            return false;
        }
        try {
            certificate2.verify(certificate2.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CoreFoundationExt.Error validateCertificate(SecurityFramework.SecCertificateRef certificateRef) {
        SecurityFramework.SecPolicyRef policy = null;
        SecurityFramework.SecTrustRefByReference secTrustRefByReference = null;
        CoreFoundation.CFArrayRef subjCerts = null;
        try {
            subjCerts = CoreFoundationExtUtil.createArray(new CoreFoundation.CFTypeRef[]{certificateRef});
            secTrustRefByReference = new SecurityFramework.SecTrustRefByReference();
            policy = SecurityFramework.INSTANCE.SecPolicyCreateSSL(false, null);
            SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustCreateWithCertificates(subjCerts, policy, secTrustRefByReference);
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                String description2 = "Failed to create trust object: " + String.valueOf((Object)rc);
                LOGGER.warning(description2);
                CoreFoundationExt.Error error2 = rc.toError();
                return error2;
            }
            CoreFoundationExt.CFErrorRef.ByReference errorRef = new CoreFoundationExt.CFErrorRef.ByReference();
            boolean trusted = SecurityFramework.INSTANCE.SecTrustEvaluateWithError(secTrustRefByReference.getSecTrustRef(), errorRef);
            if (!trusted) {
                CoreFoundationExt.CFErrorRef error3 = errorRef.getErrorRefValue();
                CoreFoundationExt.Error error4 = error3.toError();
                return error4;
            }
            CoreFoundationExt.Error error5 = null;
            return error5;
        }
        finally {
            SecurityFramework.SecTrustRef secTrustRef;
            if (policy != null) {
                policy.release();
            }
            if (secTrustRefByReference != null && (secTrustRef = secTrustRefByReference.getSecTrustRef()) != null) {
                secTrustRef.release();
            }
            if (subjCerts != null) {
                subjCerts.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrustedRoot(SecurityFramework.SecCertificateRef certificateRef) {
        boolean selfSignedCertificate = SecurityFrameworkUtil.isSelfSignedCertificate(SecurityFrameworkUtil.getX509Certificate(certificateRef));
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef);
        CoreFoundation.CFArrayRef trustedSettingsArray = trustedSettingsRef == null ? null : trustedSettingsRef.getArray();
        try {
            String certificateDescription = CoreFoundationExtUtil.getDescription(certificateRef);
            if (trustedSettingsArray == null) {
                CoreFoundationExt.Error error2 = SecurityFrameworkUtil.validateCertificate(certificateRef);
                if (error2 == null) {
                    boolean bl = true;
                    return bl;
                }
                LOGGER.fine("Certificate '" + certificateDescription + "' has no trust settings and failed to validate against trusted roots: " + String.valueOf(error2));
                boolean bl = false;
                return bl;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                try {
                    String description2 = CoreFoundationExtUtil.getDescription((CoreFoundation.CFTypeRef)trustedSettingsArray);
                    LOGGER.fine("Certificate '" + certificateDescription + "' trust settings:\n" + description2);
                }
                catch (Throwable t2) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to describe certificate trusted settings", t2));
                }
            }
            if (trustedSettingsArray.getCount() == 0) {
                boolean t2 = true;
                return t2;
            }
            for (int i2 = 0; i2 < trustedSettingsArray.getCount(); ++i2) {
                SecurityFramework.SecTrustSettingsResult result2;
                CoreFoundation.CFDictionaryRef constraints = new CoreFoundation.CFDictionaryRef(trustedSettingsArray.getValueAtIndex(i2));
                CoreFoundation.CFIndex constraintsCount = CoreFoundationExt.INSTANCE.CFDictionaryGetCount(constraints);
                int processedConstrains = 0;
                Pointer value2 = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsResult);
                if (value2 == null) {
                    result2 = SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot;
                } else {
                    CoreFoundation.CFNumberRef resultNumber = new CoreFoundation.CFNumberRef(value2);
                    result2 = new SecurityFramework.SecTrustSettingsResult(resultNumber.longValue());
                    ++processedConstrains;
                }
                if (!result2.equals((Object)SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot)) continue;
                if (!selfSignedCertificate) {
                    LOGGER.warning("Certificate '" + certificateDescription + "' is not self-signed, skipping");
                    continue;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsAllowedError) != null) {
                    ++processedConstrains;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicyName) != null) {
                    ++processedConstrains;
                }
                if ((value2 = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicy)) != null) {
                    SecurityFramework.SecPolicyRef secPolicyRef = new SecurityFramework.SecPolicyRef(value2);
                    CoreFoundation.CFDictionaryRef policyDictionaryRef = SecurityFramework.INSTANCE.SecPolicyCopyProperties(secPolicyRef);
                    try {
                        CoreFoundation.CFStringRef policyOidStringRef;
                        Pointer policyOid = policyDictionaryRef.getValue((PointerType)SecurityFramework.kSecPolicyOid);
                        if (policyOid == null || !CoreFoundationExt.INSTANCE.CFEqual((CoreFoundation.CFTypeRef)SecurityFramework.kSecPolicyAppleSSL, (CoreFoundation.CFTypeRef)(policyOidStringRef = new CoreFoundation.CFStringRef(policyOid)))) {
                            continue;
                        }
                    }
                    finally {
                        policyDictionaryRef.release();
                    }
                    ++processedConstrains;
                }
                if (constraintsCount.longValue() != (long)processedConstrains) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (trustedSettingsArray != null) {
                trustedSettingsArray.release();
            }
        }
    }

    @Nullable
    private static CoreFoundationExt.CFArrayRefByReference copyTrustSettings(SecurityFramework.SecCertificateRef certificateRef) {
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef, SecurityFramework.SecTrustSettingsDomain.user);
        if (trustedSettingsRef == null) {
            trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef, SecurityFramework.SecTrustSettingsDomain.admin);
        }
        return trustedSettingsRef;
    }

    @Nullable
    private static CoreFoundationExt.CFArrayRefByReference copyTrustSettings(SecurityFramework.SecCertificateRef certificateRef, SecurityFramework.SecTrustSettingsDomain domain) {
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = new CoreFoundationExt.CFArrayRefByReference();
        SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustSettingsCopyTrustSettings(certificateRef, domain, trustedSettingsRef);
        if (SecurityFramework.OSStatus.errSecItemNotFound.equals((Object)rc)) {
            return null;
        }
        if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
            String certificateDescription = CoreFoundationExtUtil.getDescription(certificateRef);
            throw new IllegalStateException("Failed to get trust settings for certificate '" + certificateDescription + "': " + String.valueOf(rc.toError()));
        }
        return trustedSettingsRef;
    }
}

