/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.linux;

import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.linux.PemReaderUtil;

public class LinuxTrustedCertificatesUtil {
    private static final Logger LOGGER = Logger.getLogger(LinuxTrustedCertificatesUtil.class.getName());
    private static final List<String> possibleFiles = List.of("/etc/ssl/certs/ca-certificates.crt", "/etc/pki/tls/certs/ca-bundle.crt", "/etc/ssl/ca-bundle.pem", "/etc/pki/tls/cacert.pem", "/etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem", "/etc/ssl/cert.pem");
    private static final List<String> possibleDirectories = List.of("/etc/ssl/certs", "/etc/pki/tls/certs", "/system/etc/security/cacerts");

    public static Collection<X509Certificate> getSystemCertificates() {
        HashSet<X509Certificate> result2 = new HashSet<X509Certificate>();
        for (String file : possibleFiles) {
            result2.addAll(LinuxTrustedCertificatesUtil.tryReadFromFile(Path.of(file, new String[0])));
        }
        for (String dir : possibleDirectories) {
            result2.addAll(LinuxTrustedCertificatesUtil.tryReadFromDirectory(Path.of(dir, new String[0])));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message2 = new StringBuilder();
            message2.append(result2.size()).append(" certificates were read from various system locations");
            for (X509Certificate certificate2 : result2) {
                message2.append("\n  ").append(certificate2.getSubjectDN());
            }
            LOGGER.fine(message2.toString());
        }
        return result2;
    }

    private static Set<X509Certificate> tryReadFromDirectory(@NotNull Path dir) {
        HashSet<X509Certificate> hashSet;
        block10: {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                LOGGER.fine("Not reading certificates from " + String.valueOf(dir) + ": not a directory");
                return Collections.emptySet();
            }
            LOGGER.fine("Reading certificates from " + String.valueOf(dir) + ": file does not exist");
            Stream<Path> filesStream = Files.list(dir);
            try {
                List paths = filesStream.collect(Collectors.toList());
                HashSet<X509Certificate> result2 = new HashSet<X509Certificate>();
                for (Path path2 : paths) {
                    if (!Files.isRegularFile(path2, new LinkOption[0])) continue;
                    result2.addAll(LinuxTrustedCertificatesUtil.tryReadFromFile(path2));
                }
                hashSet = result2;
                if (filesStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (filesStream != null) {
                        try {
                            filesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t2) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to read certificates from directory " + String.valueOf(dir), t2));
                    return Collections.emptySet();
                }
            }
            filesStream.close();
        }
        return hashSet;
    }

    private static List<X509Certificate> tryReadFromFile(@NotNull Path file) {
        List<X509Certificate> list2;
        block13: {
            if (!Files.exists(file, new LinkOption[0])) {
                LOGGER.fine("Not reading certificates from " + String.valueOf(file) + ": file does not exist");
                return Collections.emptyList();
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                LOGGER.warning("Not reading certificates from " + String.valueOf(file) + ": not a regular file");
                return Collections.emptyList();
            }
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            try {
                List<X509Certificate> list3 = PemReaderUtil.readPemBundle(stream, file.toString());
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder message2 = new StringBuilder();
                    message2.append("Received ").append(list3.size()).append(" certificates from ").append(file);
                    for (X509Certificate certificate2 : list3) {
                        message2.append("\n  ").append(certificate2.getSubjectDN());
                    }
                    LOGGER.fine(message2.toString());
                }
                list2 = list3;
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessDeniedException t2) {
                    LOGGER.warning("Not reading certificates from " + String.valueOf(file) + ": access denied");
                    return Collections.emptyList();
                }
                catch (Throwable t3) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to read certificates from " + String.valueOf(file), t3));
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list2;
    }
}

