/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;

public final class ImageParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            if (Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.EXCLAMATION_MARK) && Intrinsics.areEqual((Object)iterator2.rawLookup(1), (Object)MarkdownTokenTypes.LBRACKET)) {
                LocalParsingResult link;
                LocalParsingResult localParsingResult = InlineLinkParser.Companion.parseInlineLink(iterator2.advance());
                if (localParsingResult == null) {
                    localParsingResult = ReferenceLinkParser.Companion.parseReferenceLink(iterator2.advance());
                }
                if ((link = localParsingResult) != null) {
                    result2 = result2.withNode(new SequentialParser.Node(new IntRange(iterator2.getIndex(), link.getIteratorPosition().getIndex() + 1), MarkdownElementTypes.IMAGE)).withOtherParsingResult(link);
                    iterator2 = link.getIteratorPosition().advance();
                    continue;
                }
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result2.withFurtherProcessing(delegateIndices.get());
    }
}

