/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

public final class EmphasisLikeParser
implements SequentialParser {
    @NotNull
    private final DelimiterParser[] parsers;

    public EmphasisLikeParser(DelimiterParser ... parsers) {
        Intrinsics.checkNotNullParameter((Object)parsers, (String)"parsers");
        this.parsers = parsers;
    }

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        TokensCache.RangesListIterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        ArrayList<DelimiterParser.Info> delimiters = this.collectDelimiters(tokens, iterator2);
        this.balanceDelimiters(delimiters);
        for (DelimiterParser parser : this.parsers) {
            parser.process(tokens, iterator2, (List<DelimiterParser.Info>)delimiters, result2);
        }
        return result2;
    }

    private final ArrayList<DelimiterParser.Info> collectDelimiters(TokensCache tokens, TokensCache.Iterator iterator2) {
        ArrayList<DelimiterParser.Info> delimiters = new ArrayList<DelimiterParser.Info>();
        TokensCache.Iterator position = iterator2;
        block0: while (position.getType() != null) {
            int iteratorMoved = 0;
            for (DelimiterParser parser : this.parsers) {
                int steps = parser.scan(tokens, position, (List<DelimiterParser.Info>)delimiters);
                iteratorMoved += steps;
                for (int step = 0; step < steps; ++step) {
                    if (position.getType() == null) break block0;
                    position = position.advance();
                }
            }
            if (iteratorMoved != 0) continue;
            position = position.advance();
        }
        return delimiters;
    }

    private final void balanceDelimiters(ArrayList<DelimiterParser.Info> delimiters) {
        int runStartIndex = 0;
        int previousDelimiterIndex = -2;
        int n = 0;
        int n2 = delimiters.size();
        Integer[] integerArray = new Integer[n2];
        while (n < n2) {
            int n3 = n++;
            integerArray[n3] = 0;
        }
        Integer[] openersIndices = integerArray;
        HashMap openersBottom = new HashMap();
        Iterator iterator2 = ((Iterable)delimiters).iterator();
        int n4 = 0;
        while (iterator2.hasNext()) {
            int openerIndex;
            int closerIndex = n4++;
            DelimiterParser.Info closer = (DelimiterParser.Info)iterator2.next();
            if (delimiters.get(runStartIndex).getMarker() != closer.getMarker() || previousDelimiterIndex != closer.getPosition() - 1) {
                runStartIndex = closerIndex;
            }
            previousDelimiterIndex = closer.getPosition();
            if (!closer.getCanClose()) continue;
            if (!openersBottom.containsKey(Character.valueOf(closer.getMarker()))) {
                Map map2 = openersBottom;
                Character c = Character.valueOf(closer.getMarker());
                Integer[] integerArray2 = new Integer[]{-1, -1, -1, -1, -1, -1};
                map2.put(c, integerArray2);
            }
            Object v = openersBottom.get(Character.valueOf(closer.getMarker()));
            Intrinsics.checkNotNull(v);
            int minOpenerIndex = ((Integer[])v)[(closer.getCanOpen() ? 3 : 0) + closer.getLength() % 3];
            int newMinOpenerIndex = openerIndex = runStartIndex - openersIndices[runStartIndex] - 1;
            while (openerIndex > minOpenerIndex) {
                DelimiterParser.Info opener;
                Intrinsics.checkNotNullExpressionValue((Object)delimiters.get(openerIndex), (String)"delimiters[openerIndex]");
                if (opener.getMarker() != closer.getMarker()) {
                    openerIndex -= openersIndices[openerIndex] + 1;
                    continue;
                }
                if (opener.getCanOpen() && opener.getCloserIndex() < 0 && !this.violatesRuleOfThree(opener, closer)) {
                    int lastIndex = openerIndex > 0 && !delimiters.get(openerIndex - 1).getCanOpen() ? openersIndices[openerIndex - 1] + 1 : 0;
                    openersIndices[openerIndex] = lastIndex;
                    openersIndices[closerIndex] = closerIndex - openerIndex + lastIndex;
                    closer.setCanOpen(false);
                    opener.setCloserIndex(closerIndex);
                    opener.setCanClose(false);
                    newMinOpenerIndex = -1;
                    previousDelimiterIndex = -2;
                    break;
                }
                openerIndex -= openersIndices[openerIndex] + 1;
            }
            if (newMinOpenerIndex == -1) continue;
            Object v2 = openersBottom.get(Character.valueOf(closer.getMarker()));
            Intrinsics.checkNotNull(v2);
            ((Integer[])v2)[(closer.getCanOpen() ? 3 : 0) + closer.getLength() % 3] = newMinOpenerIndex;
        }
    }

    private final boolean violatesRuleOfThree(DelimiterParser.Info opener, DelimiterParser.Info closer) {
        return !(!opener.getCanClose() && !closer.getCanOpen() || (opener.getLength() + closer.getLength()) % 3 != 0 || opener.getLength() % 3 == 0 && closer.getLength() % 3 == 0);
    }
}

