/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.SetextHeaderMarkerBlock;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSetextHeaderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetextHeaderProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/SetextHeaderProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class SetextHeaderProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex REGEX = new Regex("^ {0,3}(-+|=+) *$");

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (stateInfo.getParagraphBlock() != null) {
            return CollectionsKt.emptyList();
        }
        MarkdownConstraints currentConstaints = stateInfo.getCurrentConstraints();
        if (!Intrinsics.areEqual((Object)stateInfo.getNextConstraints(), (Object)currentConstaints)) {
            return CollectionsKt.emptyList();
        }
        if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstaints)) {
            boolean bl;
            CharSequence charSequence = this.getNextLineFromConstraints(pos, currentConstaints);
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl2 = false;
                bl = REGEX.matches(it);
            } else {
                bl = false;
            }
            if (bl) {
                return CollectionsKt.listOf((Object)new SetextHeaderMarkerBlock(currentConstaints, productionHolder));
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }

    private final CharSequence getNextLineFromConstraints(LookaheadText.Position pos, MarkdownConstraints constraints) {
        String string = pos.getNextLine();
        if (string == null) {
            return null;
        }
        String line = string;
        MarkdownConstraints nextLineConstraints = constraints.applyToNextLine(pos.nextLinePosition());
        if (MarkdownConstraintsKt.extendsPrev(nextLineConstraints, constraints)) {
            return MarkdownConstraintsKt.eatItselfFromString(nextLineConstraints, line);
        }
        return null;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

