/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeBlockMarkerBlock;
import org.jetbrains.annotations.NotNull;

public final class CodeBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (MarkdownConstraintsKt.getCharsEaten(stateInfo.getNextConstraints(), pos.getCurrentLine()) > pos.getOffsetInCurrentLine()) {
            return CollectionsKt.emptyList();
        }
        Integer n = pos.charsToNonWhitespace();
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int charsToNonWhitespace = n;
        LookaheadText.Position position = pos.nextPosition(charsToNonWhitespace);
        if (position == null) {
            return CollectionsKt.emptyList();
        }
        LookaheadText.Position blockStart = position;
        if (MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(blockStart, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.listOf((Object)new CodeBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }
}

