/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TokenInfo {
    @Nullable
    private final IElementType type;
    private final int tokenStart;
    private final int tokenEnd;
    private final int rawIndex;
    private final int normIndex;

    public TokenInfo(@Nullable IElementType type2, int tokenStart, int tokenEnd, int rawIndex, int normIndex) {
        this.type = type2;
        this.tokenStart = tokenStart;
        this.tokenEnd = tokenEnd;
        this.rawIndex = rawIndex;
        this.normIndex = normIndex;
    }

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    public final int getRawIndex() {
        return this.rawIndex;
    }

    public final int getNormIndex() {
        return this.normIndex;
    }

    @NotNull
    public String toString() {
        return "TokenInfo(type=" + this.type + ", tokenStart=" + this.tokenStart + ", tokenEnd=" + this.tokenEnd + ", rawIndex=" + this.rawIndex + ", normIndex=" + this.normIndex + ')';
    }

    public int hashCode() {
        int result2 = this.type == null ? 0 : this.type.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.tokenStart);
        result2 = result2 * 31 + Integer.hashCode(this.tokenEnd);
        result2 = result2 * 31 + Integer.hashCode(this.rawIndex);
        result2 = result2 * 31 + Integer.hashCode(this.normIndex);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TokenInfo)) {
            return false;
        }
        TokenInfo tokenInfo = (TokenInfo)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)tokenInfo.type)) {
            return false;
        }
        if (this.tokenStart != tokenInfo.tokenStart) {
            return false;
        }
        if (this.tokenEnd != tokenInfo.tokenEnd) {
            return false;
        }
        if (this.rawIndex != tokenInfo.rawIndex) {
            return false;
        }
        return this.normIndex == tokenInfo.normIndex;
    }
}

