/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMarkdownLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLexer.kt\norg/intellij/markdown/lexer/MarkdownLexer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public class MarkdownLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeneratedLexer baseLexer;
    @Nullable
    private IElementType type;
    @Nullable
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final int state;
    @NotNull
    private static final Set<IElementType> TOKENS_TO_MERGE;

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
        this.state = this.baseLexer.getState();
    }

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd, int state2) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        this.reset(originalText, bufferStart, bufferEnd, state2);
        this.calcNextType();
    }

    public static /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = charSequence.length();
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        markdownLexer.start(charSequence, n, n2, n3);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        IElementType it;
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
            it = this.type;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)this.nextType, (Object)it) && it != null && TOKENS_TO_MERGE.contains(it));
    }

    private final IElementType advanceBase() {
        return this.baseLexer.advance();
    }

    public final void reset(@NotNull CharSequence buffer, int start2, int end, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.originalText = buffer;
        this.bufferStart = start2;
        this.bufferEnd = end;
        this.baseLexer.reset(buffer, start2, end, initialState);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
    }

    static {
        Object[] objectArray = new IElementType[]{MarkdownTokenTypes.TEXT, MarkdownTokenTypes.WHITE_SPACE, MarkdownTokenTypes.CODE_LINE, MarkdownTokenTypes.LINK_ID, MarkdownTokenTypes.LINK_TITLE, MarkdownTokenTypes.URL, MarkdownTokenTypes.AUTOLINK, MarkdownTokenTypes.EMAIL_AUTOLINK, MarkdownTokenTypes.BAD_CHARACTER};
        TOKENS_TO_MERGE = SetsKt.setOf((Object[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

