/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freedesktop.IStatusNotifierItem;
import org.freedesktop.IStatusNotifierWatcher;
import org.freedesktop.Pixmap;
import org.freedesktop.Point;
import org.freedesktop.StatusNotifierListener;
import org.freedesktop.StatusNotifierScrollListener;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;

class StatusNotifierItemImpl
implements IStatusNotifierItem,
Properties {
    private static final String WATCHER_BUSNAME = "org.kde.StatusNotifierWatcher";
    private static final String WATCHER_OBJECTPATH = "/StatusNotifierWatcher";
    private static final String SNI_OBJECTPATH = "/StatusNotifierItem";
    private final String serviceName;
    private final Map<String, Variant<?>> myProperties = new HashMap();
    private StatusNotifierListener myActivateListener;
    private StatusNotifierListener mySecondaryActivateListener;
    private StatusNotifierScrollListener myScrollListener;

    public StatusNotifierItemImpl(String serviceName, String title2, IStatusNotifierItem.Category category, List<Pixmap> pixmaps, String iconName, String iconThemePath) throws DBusException {
        this.serviceName = serviceName;
        int lastDot = serviceName.lastIndexOf(46);
        String id = 0 < lastDot ? serviceName.substring(lastDot + 1) : serviceName;
        this.myProperties.put("Id", new Variant((Object)id));
        this.myProperties.put("Title", new Variant((Object)title2));
        this.myProperties.put("Tooltip", new Variant((Object)title2));
        this.myProperties.put("Status", new Variant((Object)"Active"));
        this.myProperties.put("Category", new Variant((Object)category.toString()));
        this.myProperties.put("IconName", new Variant((Object)iconName));
        Pixmap[] pixmapArray = new Pixmap[pixmaps.size()];
        pixmaps.toArray(pixmapArray);
        this.myProperties.put("IconPixmap", new Variant((Object)pixmapArray));
        this.myProperties.put("IconThemePath", new Variant((Object)iconThemePath));
        this.myProperties.put("ItemIsMenu", new Variant((Object)false));
        this.myProperties.put("Menu", new Variant((Object)new ObjectPath(null, "/MenuBar")));
        this.myProperties.put("WindowId", new Variant((Object)new UInt32(0L)));
        DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        connection.requestBusName(serviceName);
        connection.exportObject(SNI_OBJECTPATH, (DBusInterface)this);
        IStatusNotifierWatcher watcher = (IStatusNotifierWatcher)connection.getRemoteObject(WATCHER_BUSNAME, WATCHER_OBJECTPATH, IStatusNotifierWatcher.class);
        watcher.RegisterStatusNotifierItem(serviceName);
    }

    public void unregister() throws DBusException {
        DBusConnection connection = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
        connection.unExportObject(SNI_OBJECTPATH);
        connection.releaseBusName(this.serviceName);
    }

    public <A> A Get(String s, String s1) {
        return (A)this.myProperties.get(s1);
    }

    public <A> void Set(String s, String s1, A a) {
    }

    public Map<String, Variant<?>> GetAll(String s) {
        return this.myProperties;
    }

    @Override
    public void Activate(int x, int y) {
        if (this.myActivateListener != null) {
            this.myActivateListener.onActivate(new Point(x, y));
        }
    }

    public void addActivateListener(StatusNotifierListener listener) {
        this.myActivateListener = listener;
    }

    @Override
    public void SecondaryActivate(int x, int y) {
        if (this.mySecondaryActivateListener != null) {
            this.mySecondaryActivateListener.onActivate(new Point(x, y));
        }
    }

    public void addSecondaryActivateListener(StatusNotifierListener listener) {
        this.mySecondaryActivateListener = listener;
    }

    @Override
    public void Scroll(int delta, String orientation) {
        if (this.myScrollListener != null) {
            this.myScrollListener.onScroll(delta, orientation);
        }
    }

    public void addSecondaryActivateListener(StatusNotifierScrollListener listener) {
        this.myScrollListener = listener;
    }

    public boolean isRemote() {
        return false;
    }

    public String getObjectPath() {
        return SNI_OBJECTPATH;
    }
}

