/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

public class UTF8 {
    private static final short[] firstUnitTable = new short[128];
    private static final byte[] transitionTable = new byte[112];

    private static void fill(byte[] byArray, int n, int n2, byte by) {
        for (int j = n; j <= n2; ++j) {
            byArray[j] = by;
        }
    }

    public static int transcodeToUTF16(byte[] byArray, char[] cArray) {
        return UTF8.transcodeToUTF16(byArray, 0, byArray.length, cArray);
    }

    public static int transcodeToUTF16(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = n;
        int n4 = 0;
        int n5 = n + n2;
        while (n3 < n5) {
            byte by;
            if ((by = byArray[n3++]) >= 0) {
                if (n4 >= cArray.length) {
                    return -1;
                }
                cArray[n4++] = (char)by;
                continue;
            }
            short s = firstUnitTable[by & 0x7F];
            int n6 = s >>> 8;
            byte by2 = (byte)s;
            while (by2 >= 0) {
                if (n3 >= n5) {
                    return -1;
                }
                by = byArray[n3++];
                n6 = n6 << 6 | by & 0x3F;
                by2 = transitionTable[by2 + ((by & 0xFF) >>> 4)];
            }
            if (by2 == -2) {
                return -1;
            }
            if (n6 <= 65535) {
                if (n4 >= cArray.length) {
                    return -1;
                }
                cArray[n4++] = (char)n6;
                continue;
            }
            if (n4 >= cArray.length - 1) {
                return -1;
            }
            cArray[n4++] = (char)(55232 + (n6 >>> 10));
            cArray[n4++] = (char)(0xDC00 | n6 & 0x3FF);
        }
        return n4;
    }

    static {
        byte[] byArray = new byte[128];
        UTF8.fill(byArray, 0, 15, (byte)1);
        UTF8.fill(byArray, 16, 31, (byte)2);
        UTF8.fill(byArray, 32, 63, (byte)3);
        UTF8.fill(byArray, 64, 65, (byte)0);
        UTF8.fill(byArray, 66, 95, (byte)4);
        UTF8.fill(byArray, 96, 96, (byte)5);
        UTF8.fill(byArray, 97, 108, (byte)6);
        UTF8.fill(byArray, 109, 109, (byte)7);
        UTF8.fill(byArray, 110, 111, (byte)6);
        UTF8.fill(byArray, 112, 112, (byte)8);
        UTF8.fill(byArray, 113, 115, (byte)9);
        UTF8.fill(byArray, 116, 116, (byte)10);
        UTF8.fill(byArray, 117, 127, (byte)0);
        UTF8.fill(transitionTable, 0, transitionTable.length - 1, (byte)-2);
        UTF8.fill(transitionTable, 8, 11, (byte)-1);
        UTF8.fill(transitionTable, 24, 27, (byte)0);
        UTF8.fill(transitionTable, 40, 43, (byte)16);
        UTF8.fill(transitionTable, 58, 59, (byte)0);
        UTF8.fill(transitionTable, 72, 73, (byte)0);
        UTF8.fill(transitionTable, 89, 91, (byte)16);
        UTF8.fill(transitionTable, 104, 104, (byte)16);
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 31, 15, 15, 15, 7, 7, 7};
        byte[] byArray3 = new byte[]{-2, -2, -2, -2, 0, 48, 16, 64, 80, 32, 96};
        for (int j = 0; j < 128; ++j) {
            byte by = byArray[j];
            int n = j & byArray2[by];
            byte by2 = byArray3[by];
            UTF8.firstUnitTable[j] = (short)(n << 8 | by2);
        }
    }
}

