/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.jcajce;

import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jcajce.CompositePublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RawContentVerifier;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.io.TeeOutputStream;

public class JcaContentVerifierProviderBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());

    public ContentVerifierProvider build(final X509Certificate x509Certificate) throws OperatorCreationException {
        JcaX509CertificateHolder jcaX509CertificateHolder;
        try {
            jcaX509CertificateHolder = new JcaX509CertificateHolder(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new OperatorCreationException("cannot process certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        return new ContentVerifierProvider(){

            @Override
            public boolean hasAssociatedCertificate() {
                return true;
            }

            @Override
            public X509CertificateHolder getAssociatedCertificate() {
                return jcaX509CertificateHolder;
            }

            @Override
            public ContentVerifier get(AlgorithmIdentifier algorithmIdentifier2) throws OperatorCreationException {
                Signature signature;
                if (algorithmIdentifier2.getAlgorithm().equals(MiscObjectIdentifiers.id_alg_composite)) {
                    return JcaContentVerifierProviderBuilder.this.createCompositeVerifier(algorithmIdentifier2, x509Certificate.getPublicKey());
                }
                try {
                    signature = JcaContentVerifierProviderBuilder.this.helper.createSignature(algorithmIdentifier2);
                    signature.initVerify(x509Certificate.getPublicKey());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
                }
                Signature signature2 = JcaContentVerifierProviderBuilder.this.createRawSig(algorithmIdentifier2, x509Certificate.getPublicKey());
                if (signature2 != null) {
                    return new RawSigVerifier(algorithmIdentifier2, signature, signature2);
                }
                return new SigVerifier(algorithmIdentifier2, signature);
            }
        };
    }

    private ContentVerifier createCompositeVerifier(AlgorithmIdentifier algorithmIdentifier2, PublicKey publicKey) throws OperatorCreationException {
        if (publicKey instanceof CompositePublicKey) {
            List<PublicKey> list2 = ((CompositePublicKey)publicKey).getPublicKeys();
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(algorithmIdentifier2.getParameters());
            Signature[] signatureArray = new Signature[aSN1Sequence.size()];
            for (int j = 0; j != aSN1Sequence.size(); ++j) {
                AlgorithmIdentifier algorithmIdentifier3 = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(j));
                signatureArray[j] = list2.get(j) != null ? this.createSignature(algorithmIdentifier3, list2.get(j)) : null;
            }
            return new CompositeVerifier(signatureArray);
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(algorithmIdentifier2.getParameters());
        Signature[] signatureArray = new Signature[aSN1Sequence.size()];
        for (int j = 0; j != aSN1Sequence.size(); ++j) {
            AlgorithmIdentifier algorithmIdentifier4 = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(j));
            try {
                signatureArray[j] = this.createSignature(algorithmIdentifier4, publicKey);
                continue;
            }
            catch (Exception exception) {
                signatureArray[j] = null;
            }
        }
        return new CompositeVerifier(signatureArray);
    }

    private Signature createSignature(AlgorithmIdentifier algorithmIdentifier2, PublicKey publicKey) throws OperatorCreationException {
        try {
            Signature signature = this.helper.createSignature(algorithmIdentifier2);
            signature.initVerify(publicKey);
            return signature;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new OperatorCreationException("exception on setup: " + generalSecurityException, generalSecurityException);
        }
    }

    private Signature createRawSig(AlgorithmIdentifier algorithmIdentifier2, PublicKey publicKey) {
        Signature signature;
        try {
            signature = this.helper.createRawSignature(algorithmIdentifier2);
            if (signature != null) {
                signature.initVerify(publicKey);
            }
        }
        catch (Exception exception) {
            signature = null;
        }
        return signature;
    }

    private static class CompositeVerifier
    implements ContentVerifier {
        private Signature[] sigs;
        private OutputStream stream;

        public CompositeVerifier(Signature[] signatureArray) throws OperatorCreationException {
            int n;
            this.sigs = signatureArray;
            for (n = 0; n < signatureArray.length && signatureArray[n] == null; ++n) {
            }
            if (n == signatureArray.length) {
                throw new OperatorCreationException("no matching signature found in composite");
            }
            this.stream = OutputStreamFactory.createStream(signatureArray[n]);
            for (int j = n + 1; j != signatureArray.length; ++j) {
                if (signatureArray[j] == null) continue;
                this.stream = new TeeOutputStream(this.stream, OutputStreamFactory.createStream(signatureArray[j]));
            }
        }

        @Override
        public OutputStream getOutputStream() {
            return this.stream;
        }

        @Override
        public boolean verify(byte[] byArray) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(byArray);
                boolean bl = false;
                for (int j = 0; j != aSN1Sequence.size(); ++j) {
                    if (this.sigs[j] == null || this.sigs[j].verify(ASN1BitString.getInstance(aSN1Sequence.getObjectAt(j)).getOctets())) continue;
                    bl = true;
                }
                return !bl;
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }

    private static class RawSigVerifier
    extends SigVerifier
    implements RawContentVerifier {
        private Signature rawSignature;

        RawSigVerifier(AlgorithmIdentifier algorithmIdentifier2, Signature signature, Signature signature2) {
            super(algorithmIdentifier2, signature);
            this.rawSignature = signature2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean verify(byte[] byArray) {
            try {
                boolean bl = super.verify(byArray);
                return bl;
            }
            finally {
                try {
                    this.rawSignature.verify(byArray);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public boolean verify(byte[] byArray, byte[] byArray2) {
            try {
                this.rawSignature.update(byArray);
                boolean bl = this.rawSignature.verify(byArray2);
                return bl;
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining raw signature: " + signatureException.getMessage(), signatureException);
            }
            finally {
                try {
                    this.rawSignature.verify(byArray2);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static class SigVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algorithm;
        private final Signature signature;
        protected final OutputStream stream;

        SigVerifier(AlgorithmIdentifier algorithmIdentifier2, Signature signature) {
            this.algorithm = algorithmIdentifier2;
            this.signature = signature;
            this.stream = OutputStreamFactory.createStream(signature);
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.stream == null) {
                throw new IllegalStateException("verifier not initialised");
            }
            return this.stream;
        }

        @Override
        public boolean verify(byte[] byArray) {
            try {
                return this.signature.verify(byArray);
            }
            catch (SignatureException signatureException) {
                throw new RuntimeOperatorException("exception obtaining signature: " + signatureException.getMessage(), signatureException);
            }
        }
    }
}

