/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.LinkOption;

public final class IOUtils {
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];

    public static int readFully(InputStream input, byte[] array) throws IOException {
        return IOUtils.readFully(input, array, 0, array.length);
    }

    public static int readFully(InputStream input, byte[] array, int offset, int length) throws IOException {
        if (length < 0 || offset < 0 || length + offset > array.length || length + offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        return org.apache.commons.io.IOUtils.read(input, array, offset, length);
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        int expectedLength = byteBuffer.remaining();
        int read2 = org.apache.commons.io.IOUtils.read(channel, byteBuffer);
        if (read2 < expectedLength) {
            throw new EOFException();
        }
    }

    public static byte[] readRange(InputStream input, int length) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        org.apache.commons.io.IOUtils.copyLarge(input, output2, 0L, length);
        return output2.toByteArray();
    }

    public static byte[] readRange(ReadableByteChannel input, int length) throws IOException {
        int readCount;
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        ByteBuffer b = ByteBuffer.allocate(Math.min(length, 8192));
        for (int read2 = 0; read2 < length; read2 += readCount) {
            b.limit(Math.min(length - read2, b.capacity()));
            readCount = input.read(b);
            if (readCount <= 0) break;
            output2.write(b.array(), 0, readCount);
            b.rewind();
        }
        return output2.toByteArray();
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        return org.apache.commons.io.IOUtils.skip(input, toSkip, org.apache.commons.io.IOUtils::byteArray);
    }
}

