/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import java.math.BigInteger;

public final class ZipEightByteInteger
implements Serializable {
    public static final ZipEightByteInteger ZERO = new ZipEightByteInteger(0L);
    private final BigInteger value;

    public static byte[] getBytes(BigInteger value2) {
        byte[] result2 = new byte[8];
        long val = value2.longValue();
        result2[0] = (byte)(val & 0xFFL);
        result2[1] = (byte)((val & 0xFF00L) >> 8);
        result2[2] = (byte)((val & 0xFF0000L) >> 16);
        result2[3] = (byte)((val & 0xFF000000L) >> 24);
        result2[4] = (byte)((val & 0xFF00000000L) >> 32);
        result2[5] = (byte)((val & 0xFF0000000000L) >> 40);
        result2[6] = (byte)((val & 0xFF000000000000L) >> 48);
        result2[7] = (byte)((val & 0x7F00000000000000L) >> 56);
        if (value2.testBit(63)) {
            result2[7] = (byte)(result2[7] | 0xFFFFFF80);
        }
        return result2;
    }

    public static byte[] getBytes(long value2) {
        return ZipEightByteInteger.getBytes(BigInteger.valueOf(value2));
    }

    public static long getLongValue(byte[] bytes2) {
        return ZipEightByteInteger.getLongValue(bytes2, 0);
    }

    public static long getLongValue(byte[] bytes2, int offset) {
        return ZipEightByteInteger.getValue(bytes2, offset).longValue();
    }

    public static BigInteger getValue(byte[] bytes2, int offset) {
        long value2 = (long)bytes2[offset + 7] << 56 & 0x7F00000000000000L;
        value2 += (long)bytes2[offset + 6] << 48 & 0xFF000000000000L;
        value2 += (long)bytes2[offset + 5] << 40 & 0xFF0000000000L;
        value2 += (long)bytes2[offset + 4] << 32 & 0xFF00000000L;
        value2 += (long)bytes2[offset + 3] << 24 & 0xFF000000L;
        value2 += (long)bytes2[offset + 2] << 16 & 0xFF0000L;
        value2 += (long)bytes2[offset + 1] << 8 & 0xFF00L;
        BigInteger val = BigInteger.valueOf(value2 += (long)bytes2[offset] & 0xFFL);
        return (bytes2[offset + 7] & 0xFFFFFF80) == -128 ? val.setBit(63) : val;
    }

    public ZipEightByteInteger(BigInteger value2) {
        this.value = value2;
    }

    public ZipEightByteInteger(byte[] bytes2, int offset) {
        this.value = ZipEightByteInteger.getValue(bytes2, offset);
    }

    public ZipEightByteInteger(long value2) {
        this(BigInteger.valueOf(value2));
    }

    public boolean equals(Object o) {
        if (!(o instanceof ZipEightByteInteger)) {
            return false;
        }
        return this.value.equals(((ZipEightByteInteger)o).getValue());
    }

    public byte[] getBytes() {
        return ZipEightByteInteger.getBytes(this.value);
    }

    public long getLongValue() {
        return this.value.longValue();
    }

    public BigInteger getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "ZipEightByteInteger value: " + this.value;
    }
}

