/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ResourceAlignmentExtraField
implements ZipExtraField {
    public static final ZipShort ID = new ZipShort(41246);
    private short alignment;
    private boolean allowMethodChange;
    private int padding;

    @Override
    public byte[] getCentralDirectoryData() {
        return ZipShort.getBytes(this.alignment | (this.allowMethodChange ? 32768 : 0));
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return new ZipShort(2);
    }

    @Override
    public ZipShort getHeaderId() {
        return ID;
    }

    @Override
    public byte[] getLocalFileDataData() {
        byte[] content2 = new byte[2 + this.padding];
        ZipShort.putShort(this.alignment | (this.allowMethodChange ? 32768 : 0), content2, 0);
        return content2;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(2 + this.padding);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] buffer, int offset, int length) throws ZipException {
        if (length < 2) {
            throw new ZipException("Too short content for ResourceAlignmentExtraField (0xa11e): " + length);
        }
        int alignmentValue = ZipShort.getValue(buffer, offset);
        this.alignment = (short)(alignmentValue & Short.MAX_VALUE);
        this.allowMethodChange = (alignmentValue & 0x8000) != 0;
    }

    @Override
    public void parseFromLocalFileData(byte[] buffer, int offset, int length) throws ZipException {
        this.parseFromCentralDirectoryData(buffer, offset, length);
        this.padding = length - 2;
    }
}

