/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebSocketExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final boolean perMessageDeflate;
    @JvmField
    @Nullable
    public final Integer clientMaxWindowBits;
    @JvmField
    public final boolean clientNoContextTakeover;
    @JvmField
    @Nullable
    public final Integer serverMaxWindowBits;
    @JvmField
    public final boolean serverNoContextTakeover;
    @JvmField
    public final boolean unknownValues;
    @NotNull
    private static final String HEADER_WEB_SOCKET_EXTENSION = "Sec-WebSocket-Extensions";

    public WebSocketExtensions(boolean perMessageDeflate, @Nullable Integer clientMaxWindowBits, boolean clientNoContextTakeover, @Nullable Integer serverMaxWindowBits, boolean serverNoContextTakeover, boolean unknownValues) {
        this.perMessageDeflate = perMessageDeflate;
        this.clientMaxWindowBits = clientMaxWindowBits;
        this.clientNoContextTakeover = clientNoContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.serverNoContextTakeover = serverNoContextTakeover;
        this.unknownValues = unknownValues;
    }

    public /* synthetic */ WebSocketExtensions(boolean bl, Integer n, boolean bl2, Integer n2, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = false;
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            bl2 = false;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = false;
        }
        this(bl, n, bl2, n2, bl3, bl4);
    }

    public final boolean noContextTakeover(boolean clientOriginated) {
        return clientOriginated ? this.clientNoContextTakeover : this.serverNoContextTakeover;
    }

    public final boolean component1() {
        return this.perMessageDeflate;
    }

    @Nullable
    public final Integer component2() {
        return this.clientMaxWindowBits;
    }

    public final boolean component3() {
        return this.clientNoContextTakeover;
    }

    @Nullable
    public final Integer component4() {
        return this.serverMaxWindowBits;
    }

    public final boolean component5() {
        return this.serverNoContextTakeover;
    }

    public final boolean component6() {
        return this.unknownValues;
    }

    @NotNull
    public final WebSocketExtensions copy(boolean perMessageDeflate, @Nullable Integer clientMaxWindowBits, boolean clientNoContextTakeover, @Nullable Integer serverMaxWindowBits, boolean serverNoContextTakeover, boolean unknownValues) {
        return new WebSocketExtensions(perMessageDeflate, clientMaxWindowBits, clientNoContextTakeover, serverMaxWindowBits, serverNoContextTakeover, unknownValues);
    }

    public static /* synthetic */ WebSocketExtensions copy$default(WebSocketExtensions webSocketExtensions, boolean bl, Integer n, boolean bl2, Integer n2, boolean bl3, boolean bl4, int n3, Object object) {
        if ((n3 & 1) != 0) {
            bl = webSocketExtensions.perMessageDeflate;
        }
        if ((n3 & 2) != 0) {
            n = webSocketExtensions.clientMaxWindowBits;
        }
        if ((n3 & 4) != 0) {
            bl2 = webSocketExtensions.clientNoContextTakeover;
        }
        if ((n3 & 8) != 0) {
            n2 = webSocketExtensions.serverMaxWindowBits;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = webSocketExtensions.serverNoContextTakeover;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = webSocketExtensions.unknownValues;
        }
        return webSocketExtensions.copy(bl, n, bl2, n2, bl3, bl4);
    }

    @NotNull
    public String toString() {
        return "WebSocketExtensions(perMessageDeflate=" + this.perMessageDeflate + ", clientMaxWindowBits=" + this.clientMaxWindowBits + ", clientNoContextTakeover=" + this.clientNoContextTakeover + ", serverMaxWindowBits=" + this.serverMaxWindowBits + ", serverNoContextTakeover=" + this.serverNoContextTakeover + ", unknownValues=" + this.unknownValues + ')';
    }

    public int hashCode() {
        int n = this.perMessageDeflate ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + (this.clientMaxWindowBits == null ? 0 : ((Object)this.clientMaxWindowBits).hashCode());
        int n2 = this.clientNoContextTakeover ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + (this.serverMaxWindowBits == null ? 0 : ((Object)this.serverMaxWindowBits).hashCode());
        int n3 = this.serverNoContextTakeover ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result2 = result2 * 31 + n3;
        int n4 = this.unknownValues ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        result2 = result2 * 31 + n4;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebSocketExtensions)) {
            return false;
        }
        WebSocketExtensions webSocketExtensions = (WebSocketExtensions)other;
        if (this.perMessageDeflate != webSocketExtensions.perMessageDeflate) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientMaxWindowBits, (Object)webSocketExtensions.clientMaxWindowBits)) {
            return false;
        }
        if (this.clientNoContextTakeover != webSocketExtensions.clientNoContextTakeover) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.serverMaxWindowBits, (Object)webSocketExtensions.serverMaxWindowBits)) {
            return false;
        }
        if (this.serverNoContextTakeover != webSocketExtensions.serverNoContextTakeover) {
            return false;
        }
        return this.unknownValues == webSocketExtensions.unknownValues;
    }

    public WebSocketExtensions() {
        this(false, null, false, null, false, false, 63, null);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebSocketExtensions parse(@NotNull Headers responseHeaders) throws IOException {
            Intrinsics.checkNotNullParameter((Object)responseHeaders, (String)"responseHeaders");
            boolean compressionEnabled = false;
            Integer clientMaxWindowBits = null;
            boolean clientNoContextTakeover = false;
            Integer serverMaxWindowBits = null;
            boolean serverNoContextTakeover = false;
            boolean unexpectedValues = false;
            int n = responseHeaders.size();
            for (int i2 = 0; i2 < n; ++i2) {
                if (!StringsKt.equals((String)responseHeaders.name(i2), (String)WebSocketExtensions.HEADER_WEB_SOCKET_EXTENSION, (boolean)true)) continue;
                String header = responseHeaders.value(i2);
                int pos = 0;
                while (pos < header.length()) {
                    int extensionEnd = Util.delimiterOffset$default(header, ',', pos, 0, 4, null);
                    int extensionTokenEnd = Util.delimiterOffset(header, ';', pos, extensionEnd);
                    String extensionToken = Util.trimSubstring(header, pos, extensionTokenEnd);
                    pos = extensionTokenEnd + 1;
                    if (StringsKt.equals((String)extensionToken, (String)"permessage-deflate", (boolean)true)) {
                        if (compressionEnabled) {
                            unexpectedValues = true;
                        }
                        compressionEnabled = true;
                        while (pos < extensionEnd) {
                            int parameterEnd = Util.delimiterOffset(header, ';', pos, extensionEnd);
                            int equals2 = Util.delimiterOffset(header, '=', pos, parameterEnd);
                            String name2 = Util.trimSubstring(header, pos, equals2);
                            String value2 = equals2 < parameterEnd ? StringsKt.removeSurrounding((String)Util.trimSubstring(header, equals2 + 1, parameterEnd), (CharSequence)"\"") : null;
                            pos = parameterEnd + 1;
                            if (StringsKt.equals((String)name2, (String)"client_max_window_bits", (boolean)true)) {
                                if (clientMaxWindowBits != null) {
                                    unexpectedValues = true;
                                }
                                String string = value2;
                                clientMaxWindowBits = string != null ? StringsKt.toIntOrNull((String)string) : null;
                                if (clientMaxWindowBits != null) continue;
                                unexpectedValues = true;
                                continue;
                            }
                            if (StringsKt.equals((String)name2, (String)"client_no_context_takeover", (boolean)true)) {
                                if (clientNoContextTakeover) {
                                    unexpectedValues = true;
                                }
                                if (value2 != null) {
                                    unexpectedValues = true;
                                }
                                clientNoContextTakeover = true;
                                continue;
                            }
                            if (StringsKt.equals((String)name2, (String)"server_max_window_bits", (boolean)true)) {
                                if (serverMaxWindowBits != null) {
                                    unexpectedValues = true;
                                }
                                String string = value2;
                                serverMaxWindowBits = string != null ? StringsKt.toIntOrNull((String)string) : null;
                                if (serverMaxWindowBits != null) continue;
                                unexpectedValues = true;
                                continue;
                            }
                            if (StringsKt.equals((String)name2, (String)"server_no_context_takeover", (boolean)true)) {
                                if (serverNoContextTakeover) {
                                    unexpectedValues = true;
                                }
                                if (value2 != null) {
                                    unexpectedValues = true;
                                }
                                serverNoContextTakeover = true;
                                continue;
                            }
                            unexpectedValues = true;
                        }
                        continue;
                    }
                    unexpectedValues = true;
                }
            }
            return new WebSocketExtensions(compressionEnabled, clientMaxWindowBits, clientNoContextTakeover, serverMaxWindowBits, serverNoContextTakeover, unexpectedValues);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

