/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrustRootIndex trustRootIndex;
    private static final int MAX_SIGNERS = 9;

    public BasicCertificateChainCleaner(@NotNull TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter((Object)trustRootIndex, (String)"trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    @NotNull
    public List<Certificate> clean(@NotNull List<? extends Certificate> chain, @NotNull String hostname) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Deque queue = new ArrayDeque(chain);
        List result2 = new ArrayList();
        Object e = queue.removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, (String)"queue.removeFirst()");
        result2.add(e);
        boolean foundTrustedCertificate = false;
        block0: for (int c = 0; c < 9; ++c) {
            Iterator i2;
            Object e2 = result2.get(result2.size() - 1);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate toVerify = (X509Certificate)e2;
            X509Certificate trustedCert = this.trustRootIndex.findByIssuerAndSignature(toVerify);
            if (trustedCert != null) {
                if (result2.size() > 1 || !Intrinsics.areEqual((Object)toVerify, (Object)trustedCert)) {
                    result2.add(trustedCert);
                }
                if (this.verifySignature(trustedCert, trustedCert)) {
                    return result2;
                }
                foundTrustedCertificate = true;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(queue.iterator(), (String)"queue.iterator()");
            while (i2.hasNext()) {
                Object e3 = i2.next();
                Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                X509Certificate signingCert = (X509Certificate)e3;
                if (!this.verifySignature(toVerify, signingCert)) continue;
                i2.remove();
                result2.add(signingCert);
                continue block0;
            }
            if (foundTrustedCertificate) {
                return result2;
            }
            throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + toVerify);
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + result2);
    }

    private final boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)toVerify.getIssuerDN(), (Object)signingCert.getSubjectDN())) {
            return false;
        }
        try {
            toVerify.verify(signingCert.getPublicKey());
            bl = true;
        }
        catch (GeneralSecurityException verifyFailed) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other == this ? true : other instanceof BasicCertificateChainCleaner && Intrinsics.areEqual((Object)((BasicCertificateChainCleaner)other).trustRootIndex, (Object)this.trustRootIndex);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

