/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.lang.reflect.Method;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloseGuard {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Method getMethod;
    @Nullable
    private final Method openMethod;
    @Nullable
    private final Method warnIfOpenMethod;

    public CloseGuard(@Nullable Method getMethod, @Nullable Method openMethod, @Nullable Method warnIfOpenMethod) {
        this.getMethod = getMethod;
        this.openMethod = openMethod;
        this.warnIfOpenMethod = warnIfOpenMethod;
    }

    @Nullable
    public final Object createAndOpen(@NotNull String closer) {
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        if (this.getMethod != null) {
            try {
                Object closeGuardInstance = this.getMethod.invoke(null, new Object[0]);
                Method method = this.openMethod;
                Intrinsics.checkNotNull((Object)method);
                Object[] objectArray = new Object[]{closer};
                method.invoke(closeGuardInstance, objectArray);
                return closeGuardInstance;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public final boolean warnIfOpen(@Nullable Object closeGuardInstance) {
        boolean reported = false;
        if (closeGuardInstance != null) {
            try {
                Method method = this.warnIfOpenMethod;
                Intrinsics.checkNotNull((Object)method);
                method.invoke(closeGuardInstance, new Object[0]);
                reported = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reported;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloseGuard get() {
            Method getMethod = null;
            Method openMethod = null;
            Method warnIfOpenMethod = null;
            try {
                Class<?> closeGuardClass = Class.forName("dalvik.system.CloseGuard");
                getMethod = closeGuardClass.getMethod("get", new Class[0]);
                Class[] classArray = new Class[]{String.class};
                openMethod = closeGuardClass.getMethod("open", classArray);
                warnIfOpenMethod = closeGuardClass.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception _) {
                getMethod = null;
                openMethod = null;
                warnIfOpenMethod = null;
            }
            return new CloseGuard(getMethod, openMethod, warnIfOpenMethod);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

