/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.util.Log;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.platform.android.AndroidLogHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressSignatureCheck
public final class AndroidLog {
    @NotNull
    public static final AndroidLog INSTANCE;
    private static final int MAX_LOG_LENGTH = 4000;
    @NotNull
    private static final CopyOnWriteArraySet<Logger> configuredLoggers;
    @NotNull
    private static final Map<String, String> knownLoggers;

    private AndroidLog() {
    }

    public final void androidLog$okhttp(@NotNull String loggerName, int logLevel, @NotNull String message2, @Nullable Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String tag = this.loggerTag(loggerName);
        if (Log.isLoggable((String)tag, (int)logLevel)) {
            String logMessage = message2;
            if (t2 != null) {
                logMessage = logMessage + '\n' + Log.getStackTraceString((Throwable)t2);
            }
            int length = logMessage.length();
            for (int i2 = 0; i2 < length; ++i2) {
                int end;
                int newline = StringsKt.indexOf$default((CharSequence)logMessage, (char)'\n', (int)i2, (boolean)false, (int)4, null);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i2 + 4000);
                    String string = logMessage.substring(i2, end);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    Log.println((int)logLevel, (String)tag, (String)string);
                } while ((i2 = end) < newline);
            }
        }
    }

    private final String loggerTag(String loggerName) {
        String string = knownLoggers.get(loggerName);
        if (string == null) {
            string = StringsKt.take((String)loggerName, (int)23);
        }
        return string;
    }

    public final void enable() {
        for (Map.Entry<String, String> entry : knownLoggers.entrySet()) {
            String logger = entry.getKey();
            String tag = entry.getValue();
            this.enableLogging(logger, tag);
        }
    }

    private final void enableLogging(String logger, String tag) {
        Logger logger2 = Logger.getLogger(logger);
        if (configuredLoggers.add(logger2)) {
            logger2.setUseParentHandlers(false);
            logger2.setLevel(Log.isLoggable((String)tag, (int)3) ? Level.FINE : (Log.isLoggable((String)tag, (int)4) ? Level.INFO : Level.WARNING));
            logger2.addHandler(AndroidLogHandler.INSTANCE);
        }
    }

    static {
        String packageName;
        LinkedHashMap linkedHashMap;
        INSTANCE = new AndroidLog();
        configuredLoggers = new CopyOnWriteArraySet();
        LinkedHashMap $this$knownLoggers_u24lambda_u240 = linkedHashMap = new LinkedHashMap();
        boolean bl = false;
        Package package_ = OkHttpClient.class.getPackage();
        String string = packageName = package_ != null ? package_.getName() : null;
        if (packageName != null) {
            ((Map)$this$knownLoggers_u24lambda_u240).put(packageName, "OkHttp");
        }
        Map map2 = $this$knownLoggers_u24lambda_u240;
        String string2 = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"OkHttpClient::class.java.name");
        String string3 = string2;
        String string4 = "okhttp.OkHttpClient";
        map2.put(string3, string4);
        map2 = $this$knownLoggers_u24lambda_u240;
        String string5 = Http2.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"Http2::class.java.name");
        string3 = string5;
        string4 = "okhttp.Http2";
        map2.put(string3, string4);
        map2 = $this$knownLoggers_u24lambda_u240;
        String string6 = TaskRunner.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"TaskRunner::class.java.name");
        string3 = string6;
        string4 = "okhttp.TaskRunner";
        map2.put(string3, string4);
        ((Map)$this$knownLoggers_u24lambda_u240).put("okhttp3.mockwebserver.MockWebServer", "okhttp.MockWebServer");
        knownLoggers = MapsKt.toMap((Map)linkedHashMap);
    }
}

