/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressSignatureCheck
@SourceDebugExtension(value={"SMAP\nAndroidPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n766#2:164\n857#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AndroidPlatform.kt\nokhttp3/internal/platform/AndroidPlatform\n*L\n52#1:164\n52#1:165,2\n*E\n"})
public final class AndroidPlatform
extends Platform {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<SocketAdapter> socketAdapters;
    @NotNull
    private final CloseGuard closeGuard;
    private static final boolean isSupported;

    /*
     * WARNING - void declaration
     */
    public AndroidPlatform() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object = new SocketAdapter[]{StandardAndroidSocketAdapter.Companion.buildIfSupported$default(StandardAndroidSocketAdapter.Companion, null, 1, null), new DeferredSocketAdapter(AndroidSocketAdapter.Companion.getPlayProviderFactory()), new DeferredSocketAdapter(ConscryptSocketAdapter.Companion.getFactory()), new DeferredSocketAdapter(BouncyCastleSocketAdapter.Companion.getFactory())};
        object = CollectionsKt.listOfNotNull((Object[])object);
        AndroidPlatform androidPlatform = this;
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SocketAdapter it = (SocketAdapter)element$iv$iv;
            boolean bl = false;
            if (!it.isSupported()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        androidPlatform.socketAdapters = (List)destination$iv$iv;
        this.closeGuard = CloseGuard.Companion.get();
    }

    @Override
    public void connectSocket(@NotNull Socket socket, @NotNull InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            socket.connect(address, connectTimeout);
        }
        catch (ClassCastException e) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", e);
            }
            throw e;
        }
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocketFactory(sslSocketFactory)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.trustManager(sslSocketFactory) : null;
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<Protocol> protocols) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocket(sslSocket)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            socketAdapter.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Iterable iterable = this.socketAdapters;
            for (Object t2 : iterable) {
                SocketAdapter it = (SocketAdapter)t2;
                boolean bl = false;
                if (!it.matchesSocket(sslSocket)) continue;
                v0 = t2;
                break block1;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        return socketAdapter != null ? socketAdapter.getSelectedProtocol(sslSocket) : null;
    }

    @Override
    @Nullable
    public Object getStackTraceForCloseable(@NotNull String closer) {
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        return this.closeGuard.createAndOpen(closer);
    }

    @Override
    public void logCloseableLeak(@NotNull String message2, @Nullable Object stackTrace) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        boolean reported = this.closeGuard.warnIfOpen(stackTrace);
        if (!reported) {
            Platform.log$default(this, message2, 5, null, 4, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return Build.VERSION.SDK_INT >= 24 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(hostname) : (Build.VERSION.SDK_INT >= 23 ? NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() : true);
    }

    @Override
    @NotNull
    public CertificateChainCleaner buildCertificateChainCleaner(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(trustManager);
        return androidCertificateChainCleaner != null ? (CertificateChainCleaner)androidCertificateChainCleaner : super.buildCertificateChainCleaner(trustManager);
    }

    @Override
    @NotNull
    public TrustRootIndex buildTrustRootIndex(@NotNull X509TrustManager trustManager) {
        TrustRootIndex trustRootIndex;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        try {
            Class[] classArray = new Class[]{X509Certificate.class};
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", classArray);
            method.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            trustRootIndex = new CustomTrustRootIndex(trustManager, method);
        }
        catch (NoSuchMethodException e) {
            trustRootIndex = super.buildTrustRootIndex(trustManager);
        }
        return trustRootIndex;
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        if (!Platform.Companion.isAndroid()) {
            bl = false;
        } else if (Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                boolean bl2 = false;
                String string = "Expected Android API level 21+ but was " + Build.VERSION.SDK_INT;
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupported() {
            return isSupported;
        }

        @Nullable
        public final Platform buildIfSupported() {
            return this.isSupported() ? (Platform)new AndroidPlatform() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class CustomTrustRootIndex
    implements TrustRootIndex {
        @NotNull
        private final X509TrustManager trustManager;
        @NotNull
        private final Method findByIssuerAndSignatureMethod;

        public CustomTrustRootIndex(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            Intrinsics.checkNotNullParameter((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            this.trustManager = trustManager;
            this.findByIssuerAndSignatureMethod = findByIssuerAndSignatureMethod;
        }

        @Override
        @Nullable
        public X509Certificate findByIssuerAndSignature(@NotNull X509Certificate cert) {
            X509Certificate x509Certificate;
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            try {
                Object[] objectArray = new Object[]{cert};
                Object object = this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, objectArray);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.cert.TrustAnchor");
                TrustAnchor trustAnchor = (TrustAnchor)object;
                x509Certificate = trustAnchor.getTrustedCert();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError("unable to get issues and signature", e);
            }
            catch (InvocationTargetException _) {
                x509Certificate = null;
            }
            return x509Certificate;
        }

        private final X509TrustManager component1() {
            return this.trustManager;
        }

        private final Method component2() {
            return this.findByIssuerAndSignatureMethod;
        }

        @NotNull
        public final CustomTrustRootIndex copy(@NotNull X509TrustManager trustManager, @NotNull Method findByIssuerAndSignatureMethod) {
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            Intrinsics.checkNotNullParameter((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            return new CustomTrustRootIndex(trustManager, findByIssuerAndSignatureMethod);
        }

        public static /* synthetic */ CustomTrustRootIndex copy$default(CustomTrustRootIndex customTrustRootIndex, X509TrustManager x509TrustManager, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                x509TrustManager = customTrustRootIndex.trustManager;
            }
            if ((n & 2) != 0) {
                method = customTrustRootIndex.findByIssuerAndSignatureMethod;
            }
            return customTrustRootIndex.copy(x509TrustManager, method);
        }

        @NotNull
        public String toString() {
            return "CustomTrustRootIndex(trustManager=" + this.trustManager + ", findByIssuerAndSignatureMethod=" + this.findByIssuerAndSignatureMethod + ')';
        }

        public int hashCode() {
            int result2 = this.trustManager.hashCode();
            result2 = result2 * 31 + this.findByIssuerAndSignatureMethod.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomTrustRootIndex)) {
                return false;
            }
            CustomTrustRootIndex customTrustRootIndex = (CustomTrustRootIndex)other;
            if (!Intrinsics.areEqual((Object)this.trustManager, (Object)customTrustRootIndex.trustManager)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.findByIssuerAndSignatureMethod, (Object)customTrustRootIndex.findByIssuerAndSignatureMethod);
        }
    }
}

