/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Header {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final ByteString name;
    @JvmField
    @NotNull
    public final ByteString value;
    @JvmField
    public final int hpackSize;
    @JvmField
    @NotNull
    public static final ByteString PSEUDO_PREFIX = ByteString.Companion.encodeUtf8(":");
    @NotNull
    public static final String RESPONSE_STATUS_UTF8 = ":status";
    @NotNull
    public static final String TARGET_METHOD_UTF8 = ":method";
    @NotNull
    public static final String TARGET_PATH_UTF8 = ":path";
    @NotNull
    public static final String TARGET_SCHEME_UTF8 = ":scheme";
    @NotNull
    public static final String TARGET_AUTHORITY_UTF8 = ":authority";
    @JvmField
    @NotNull
    public static final ByteString RESPONSE_STATUS = ByteString.Companion.encodeUtf8(":status");
    @JvmField
    @NotNull
    public static final ByteString TARGET_METHOD = ByteString.Companion.encodeUtf8(":method");
    @JvmField
    @NotNull
    public static final ByteString TARGET_PATH = ByteString.Companion.encodeUtf8(":path");
    @JvmField
    @NotNull
    public static final ByteString TARGET_SCHEME = ByteString.Companion.encodeUtf8(":scheme");
    @JvmField
    @NotNull
    public static final ByteString TARGET_AUTHORITY = ByteString.Companion.encodeUtf8(":authority");

    public Header(@NotNull ByteString name2, @NotNull ByteString value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.name = name2;
        this.value = value2;
        this.hpackSize = 32 + this.name.size() + this.value.size();
    }

    public Header(@NotNull String name2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this(ByteString.Companion.encodeUtf8(name2), ByteString.Companion.encodeUtf8(value2));
    }

    public Header(@NotNull ByteString name2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this(name2, ByteString.Companion.encodeUtf8(value2));
    }

    @NotNull
    public String toString() {
        return this.name.utf8() + ": " + this.value.utf8();
    }

    @NotNull
    public final ByteString component1() {
        return this.name;
    }

    @NotNull
    public final ByteString component2() {
        return this.value;
    }

    @NotNull
    public final Header copy(@NotNull ByteString name2, @NotNull ByteString value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return new Header(name2, value2);
    }

    public static /* synthetic */ Header copy$default(Header header, ByteString byteString, ByteString byteString2, int n, Object object) {
        if ((n & 1) != 0) {
            byteString = header.name;
        }
        if ((n & 2) != 0) {
            byteString2 = header.value;
        }
        return header.copy(byteString, byteString2);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Header)) {
            return false;
        }
        Header header = (Header)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)header.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)header.value);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

