/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public final class StatusLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Protocol protocol;
    @JvmField
    public final int code;
    @JvmField
    @NotNull
    public final String message;
    public static final int HTTP_TEMP_REDIRECT = 307;
    public static final int HTTP_PERM_REDIRECT = 308;
    public static final int HTTP_MISDIRECTED_REQUEST = 421;
    public static final int HTTP_CONTINUE = 100;

    public StatusLine(@NotNull Protocol protocol, int code, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.protocol = protocol;
        this.code = code;
        this.message = message2;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.protocol == Protocol.HTTP_1_0) {
            $this$toString_u24lambda_u240.append("HTTP/1.0");
        } else {
            $this$toString_u24lambda_u240.append("HTTP/1.1");
        }
        $this$toString_u24lambda_u240.append(' ').append(this.code);
        $this$toString_u24lambda_u240.append(' ').append(this.message);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusLine get(@NotNull Response response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            return new StatusLine(response2.protocol(), response2.code(), response2.message());
        }

        @NotNull
        public final StatusLine parse(@NotNull String statusLine) throws IOException {
            int n;
            Intrinsics.checkNotNullParameter((Object)statusLine, (String)"statusLine");
            int codeStart = 0;
            Protocol protocol = null;
            if (StringsKt.startsWith$default((String)statusLine, (String)"HTTP/1.", (boolean)false, (int)2, null)) {
                Protocol protocol2;
                if (statusLine.length() < 9 || statusLine.charAt(8) != ' ') {
                    throw new ProtocolException("Unexpected status line: " + statusLine);
                }
                int httpMinorVersion = statusLine.charAt(7) - 48;
                codeStart = 9;
                switch (httpMinorVersion) {
                    case 0: {
                        protocol2 = Protocol.HTTP_1_0;
                        break;
                    }
                    case 1: {
                        protocol2 = Protocol.HTTP_1_1;
                        break;
                    }
                    default: {
                        throw new ProtocolException("Unexpected status line: " + statusLine);
                    }
                }
                protocol = protocol2;
            } else if (StringsKt.startsWith$default((String)statusLine, (String)"ICY ", (boolean)false, (int)2, null)) {
                protocol = Protocol.HTTP_1_0;
                codeStart = 4;
            } else {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            if (statusLine.length() < codeStart + 3) {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            try {
                String string = statusLine.substring(codeStart, codeStart + 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException _) {
                throw new ProtocolException("Unexpected status line: " + statusLine);
            }
            int code = n;
            String message2 = "";
            if (statusLine.length() > codeStart + 3) {
                if (statusLine.charAt(codeStart + 3) != ' ') {
                    throw new ProtocolException("Unexpected status line: " + statusLine);
                }
                String string = statusLine.substring(codeStart + 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                message2 = string;
            }
            return new StatusLine(protocol, code, message2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

