/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;
import org.jetbrains.annotations.NotNull;

public final class RouteSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Address address;
    @NotNull
    private final RouteDatabase routeDatabase;
    @NotNull
    private final Call call;
    @NotNull
    private final EventListener eventListener;
    @NotNull
    private List<? extends Proxy> proxies;
    private int nextProxyIndex;
    @NotNull
    private List<? extends InetSocketAddress> inetSocketAddresses;
    @NotNull
    private final List<Route> postponedRoutes;

    public RouteSelector(@NotNull Address address, @NotNull RouteDatabase routeDatabase, @NotNull Call call2, @NotNull EventListener eventListener) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.call = call2;
        this.eventListener = eventListener;
        this.proxies = CollectionsKt.emptyList();
        this.inetSocketAddresses = CollectionsKt.emptyList();
        this.postponedRoutes = new ArrayList();
        this.resetNextProxy(this.address.url(), this.address.proxy());
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !((Collection)this.postponedRoutes).isEmpty();
    }

    @NotNull
    public final Selection next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List routes = new ArrayList();
        while (this.hasNextProxy()) {
            Proxy proxy = this.nextProxy();
            for (InetSocketAddress inetSocketAddress : this.inetSocketAddresses) {
                Route route = new Route(this.address, proxy, inetSocketAddress);
                if (this.routeDatabase.shouldPostpone(route)) {
                    ((Collection)this.postponedRoutes).add(route);
                    continue;
                }
                ((Collection)routes).add(route);
            }
            if (!(!((Collection)routes).isEmpty())) continue;
        }
        if (routes.isEmpty()) {
            CollectionsKt.addAll((Collection)routes, (Iterable)this.postponedRoutes);
            this.postponedRoutes.clear();
        }
        return new Selection(routes);
    }

    private final void resetNextProxy(HttpUrl url, Proxy proxy) {
        this.eventListener.proxySelectStart(this.call, url);
        this.proxies = RouteSelector.resetNextProxy$selectProxies(proxy, url, this);
        this.nextProxyIndex = 0;
        this.eventListener.proxySelectEnd(this.call, url, this.proxies);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private final Proxy nextProxy() throws IOException {
        if (!this.hasNextProxy()) {
            throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
        }
        int n = this.nextProxyIndex;
        this.nextProxyIndex = n + 1;
        Proxy result2 = this.proxies.get(n);
        this.resetNextInetSocketAddress(result2);
        return result2;
    }

    private final void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        List mutableInetSocketAddresses;
        this.inetSocketAddresses = mutableInetSocketAddresses = (List)new ArrayList();
        String socketHost = null;
        int socketPort = 0;
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            socketHost = this.address.url().host();
            socketPort = this.address.url().port();
        } else {
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                boolean $i$a$-require-RouteSelector$resetNextInetSocketAddress$22 = false;
                String $i$a$-require-RouteSelector$resetNextInetSocketAddress$22 = "Proxy.address() is not an InetSocketAddress: " + proxyAddress.getClass();
                throw new IllegalArgumentException($i$a$-require-RouteSelector$resetNextInetSocketAddress$22.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)proxyAddress, (String)"proxyAddress");
            socketHost = Companion.getSocketHost((InetSocketAddress)proxyAddress);
            socketPort = ((InetSocketAddress)proxyAddress).getPort();
        }
        if (!(1 <= socketPort ? socketPort < 65536 : false)) {
            throw new SocketException("No route to " + socketHost + ':' + socketPort + "; port is out of range");
        }
        if (proxy.type() == Proxy.Type.SOCKS) {
            ((Collection)mutableInetSocketAddresses).add(InetSocketAddress.createUnresolved(socketHost, socketPort));
        } else {
            List<InetAddress> list2;
            if (Util.canParseAsIpAddress(socketHost)) {
                list2 = CollectionsKt.listOf((Object)InetAddress.getByName(socketHost));
            } else {
                this.eventListener.dnsStart(this.call, socketHost);
                List<InetAddress> result2 = this.address.dns().lookup(socketHost);
                if (result2.isEmpty()) {
                    throw new UnknownHostException(this.address.dns() + " returned no addresses for " + socketHost);
                }
                this.eventListener.dnsEnd(this.call, socketHost, result2);
                list2 = result2;
            }
            List<InetAddress> addresses = list2;
            for (InetAddress inetAddress : addresses) {
                ((Collection)mutableInetSocketAddresses).add(new InetSocketAddress(inetAddress, socketPort));
            }
        }
    }

    private static final List<Proxy> resetNextProxy$selectProxies(Proxy $proxy, HttpUrl $url, RouteSelector this$0) {
        Proxy proxy = $proxy;
        if (proxy != null) {
            return CollectionsKt.listOf((Object)proxy);
        }
        URI uri = $url.uri();
        if (uri.getHost() == null) {
            Proxy[] proxyArray = new Proxy[]{Proxy.NO_PROXY};
            return Util.immutableListOf(proxyArray);
        }
        List<Proxy> proxiesOrNull = this$0.address.proxySelector().select(uri);
        Proxy[] proxyArray = (Proxy[])proxiesOrNull;
        if (proxyArray == null || proxyArray.isEmpty()) {
            proxyArray = new Proxy[]{Proxy.NO_PROXY};
            return Util.immutableListOf(proxyArray);
        }
        Intrinsics.checkNotNullExpressionValue(proxiesOrNull, (String)"proxiesOrNull");
        return Util.toImmutableList(proxiesOrNull);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSocketHost(@NotNull InetSocketAddress $this$socketHost) {
            Intrinsics.checkNotNullParameter((Object)$this$socketHost, (String)"<this>");
            InetAddress inetAddress = $this$socketHost.getAddress();
            if (inetAddress == null) {
                String string = $this$socketHost.getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hostName");
                return string;
            }
            InetAddress address = inetAddress;
            String string = address.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.hostAddress");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Selection {
        @NotNull
        private final List<Route> routes;
        private int nextRouteIndex;

        public Selection(@NotNull List<Route> routes) {
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            this.routes = routes;
        }

        @NotNull
        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        @NotNull
        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.nextRouteIndex;
            this.nextRouteIndex = n + 1;
            return this.routes.get(n);
        }
    }
}

