/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.cache2.FileOperator;
import okio.Buffer;
import okio.ByteString;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Relay {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RandomAccessFile file;
    @Nullable
    private Source upstream;
    private long upstreamPos;
    @NotNull
    private final ByteString metadata;
    private final long bufferMaxSize;
    @Nullable
    private Thread upstreamReader;
    @NotNull
    private final Buffer upstreamBuffer;
    private boolean complete;
    @NotNull
    private final Buffer buffer;
    private int sourceCount;
    private static final int SOURCE_UPSTREAM = 1;
    private static final int SOURCE_FILE = 2;
    @JvmField
    @NotNull
    public static final ByteString PREFIX_CLEAN = ByteString.Companion.encodeUtf8("OkHttp cache v1\n");
    @JvmField
    @NotNull
    public static final ByteString PREFIX_DIRTY = ByteString.Companion.encodeUtf8("OkHttp DIRTY :(\n");
    private static final long FILE_HEADER_SIZE = 32L;

    private Relay(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata2, long bufferMaxSize) {
        this.file = file;
        this.upstream = upstream;
        this.upstreamPos = upstreamPos;
        this.metadata = metadata2;
        this.bufferMaxSize = bufferMaxSize;
        this.upstreamBuffer = new Buffer();
        this.complete = this.upstream == null;
        this.buffer = new Buffer();
    }

    @Nullable
    public final RandomAccessFile getFile() {
        return this.file;
    }

    public final void setFile(@Nullable RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    @Nullable
    public final Source getUpstream() {
        return this.upstream;
    }

    public final void setUpstream(@Nullable Source source) {
        this.upstream = source;
    }

    public final long getUpstreamPos() {
        return this.upstreamPos;
    }

    public final void setUpstreamPos(long l) {
        this.upstreamPos = l;
    }

    public final long getBufferMaxSize() {
        return this.bufferMaxSize;
    }

    @Nullable
    public final Thread getUpstreamReader() {
        return this.upstreamReader;
    }

    public final void setUpstreamReader(@Nullable Thread thread2) {
        this.upstreamReader = thread2;
    }

    @NotNull
    public final Buffer getUpstreamBuffer() {
        return this.upstreamBuffer;
    }

    public final boolean getComplete() {
        return this.complete;
    }

    public final void setComplete(boolean bl) {
        this.complete = bl;
    }

    @NotNull
    public final Buffer getBuffer() {
        return this.buffer;
    }

    public final int getSourceCount() {
        return this.sourceCount;
    }

    public final void setSourceCount(int n) {
        this.sourceCount = n;
    }

    public final boolean isClosed() {
        return this.file == null;
    }

    private final void writeHeader(ByteString prefix, long upstreamSize, long metadataSize) throws IOException {
        Buffer buffer;
        Buffer $this$writeHeader_u24lambda_u240 = buffer = new Buffer();
        boolean bl = false;
        $this$writeHeader_u24lambda_u240.write(prefix);
        $this$writeHeader_u24lambda_u240.writeLong(upstreamSize);
        $this$writeHeader_u24lambda_u240.writeLong(metadataSize);
        if (!($this$writeHeader_u24lambda_u240.size() == 32L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Buffer header = buffer;
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        FileChannel fileChannel = randomAccessFile.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"file!!.channel");
        FileOperator fileOperator = new FileOperator(fileChannel);
        fileOperator.write(0L, header, 32L);
    }

    private final void writeMetadata(long upstreamSize) throws IOException {
        Buffer metadataBuffer = new Buffer();
        metadataBuffer.write(this.metadata);
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        FileChannel fileChannel = randomAccessFile.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"file!!.channel");
        FileOperator fileOperator = new FileOperator(fileChannel);
        fileOperator.write(32L + upstreamSize, metadataBuffer, this.metadata.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(long upstreamSize) throws IOException {
        this.writeMetadata(upstreamSize);
        RandomAccessFile randomAccessFile = this.file;
        Intrinsics.checkNotNull((Object)randomAccessFile);
        randomAccessFile.getChannel().force(false);
        this.writeHeader(PREFIX_CLEAN, upstreamSize, this.metadata.size());
        RandomAccessFile randomAccessFile2 = this.file;
        Intrinsics.checkNotNull((Object)randomAccessFile2);
        randomAccessFile2.getChannel().force(false);
        Relay relay2 = this;
        synchronized (relay2) {
            boolean bl = false;
            this.complete = true;
            Unit unit = Unit.INSTANCE;
        }
        Source source = this.upstream;
        if (source != null) {
            Util.closeQuietly((Closeable)source);
        }
        this.upstream = null;
    }

    @NotNull
    public final ByteString metadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Source newSource() {
        Relay relay2 = this;
        synchronized (relay2) {
            block4: {
                boolean bl = false;
                if (this.file != null) break block4;
                Source source = null;
                return source;
            }
            int n = this.sourceCount;
            this.sourceCount = n + 1;
            int n2 = n;
        }
        return new RelaySource();
    }

    public /* synthetic */ Relay(RandomAccessFile file, Source upstream, long upstreamPos, ByteString metadata2, long bufferMaxSize, DefaultConstructorMarker $constructor_marker) {
        this(file, upstream, upstreamPos, metadata2, bufferMaxSize);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Relay edit(@NotNull File file, @NotNull Source upstream, @NotNull ByteString metadata2, long bufferMaxSize) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            Relay result2 = new Relay(randomAccessFile, upstream, 0L, metadata2, bufferMaxSize, null);
            randomAccessFile.setLength(0L);
            result2.writeHeader(PREFIX_DIRTY, -1L, -1L);
            return result2;
        }

        @NotNull
        public final Relay read(@NotNull File file) throws IOException {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"randomAccessFile.channel");
            FileOperator fileOperator = new FileOperator(fileChannel);
            Buffer header = new Buffer();
            fileOperator.read(0L, header, 32L);
            ByteString prefix = header.readByteString((long)PREFIX_CLEAN.size());
            if (!Intrinsics.areEqual((Object)prefix, (Object)PREFIX_CLEAN)) {
                throw new IOException("unreadable cache file");
            }
            long upstreamSize = header.readLong();
            long metadataSize = header.readLong();
            Buffer metadataBuffer = new Buffer();
            fileOperator.read(32L + upstreamSize, metadataBuffer, metadataSize);
            ByteString metadata2 = metadataBuffer.readByteString();
            return new Relay(randomAccessFile, null, upstreamSize, metadata2, 0L, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nRelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Relay.kt\nokhttp3/internal/cache2/Relay$RelaySource\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,356:1\n563#2:357\n*S KotlinDebug\n*F\n+ 1 Relay.kt\nokhttp3/internal/cache2/Relay$RelaySource\n*L\n267#1:357\n*E\n"})
    public final class RelaySource
    implements Source {
        @NotNull
        private final Timeout timeout = new Timeout();
        @Nullable
        private FileOperator fileOperator;
        private long sourcePos;

        public RelaySource() {
            RandomAccessFile randomAccessFile = Relay.this.getFile();
            Intrinsics.checkNotNull((Object)randomAccessFile);
            FileChannel fileChannel = randomAccessFile.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"file!!.channel");
            this.fileOperator = new FileOperator(fileChannel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long read(@NotNull Buffer sink, long byteCount) throws IOException {
            Object object;
            long upstreamBytesRead;
            block21: {
                Relay bytesToRead2;
                Relay relay2;
                long l;
                int n;
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (!(this.fileOperator != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                Relay relay3 = Relay.this;
                Relay relay4 = Relay.this;
                Relay relay5 = relay3;
                synchronized (relay5) {
                    int n2;
                    block20: {
                        long upstreamPos;
                        boolean bl = false;
                        while (this.sourcePos == (upstreamPos = relay4.getUpstreamPos())) {
                            if (relay4.getComplete()) {
                                return -1L;
                            }
                            if (relay4.getUpstreamReader() != null) {
                                this.timeout.waitUntilNotified((Object)relay4);
                                continue;
                            }
                            relay4.setUpstreamReader(Thread.currentThread());
                            n2 = 1;
                            break block20;
                        }
                        long bufferPos22 = relay4.getUpstreamPos() - relay4.getBuffer().size();
                        if (this.sourcePos >= bufferPos22) {
                            long bytesToRead2 = Math.min(byteCount, relay4.getUpstreamPos() - this.sourcePos);
                            relay4.getBuffer().copyTo(sink, this.sourcePos - bufferPos22, bytesToRead2);
                            this.sourcePos += bytesToRead2;
                            return bytesToRead2;
                        }
                        n2 = 2;
                    }
                    n = n2;
                }
                int source = n;
                if (source == 2) {
                    long bytesToRead3 = Math.min(byteCount, Relay.this.getUpstreamPos() - this.sourcePos);
                    FileOperator fileOperator = this.fileOperator;
                    Intrinsics.checkNotNull((Object)fileOperator);
                    fileOperator.read(32L + this.sourcePos, sink, bytesToRead3);
                    this.sourcePos += bytesToRead3;
                    return bytesToRead3;
                }
                try {
                    Source source2 = Relay.this.getUpstream();
                    Intrinsics.checkNotNull((Object)source2);
                    upstreamBytesRead = source2.read(Relay.this.getUpstreamBuffer(), Relay.this.getBufferMaxSize());
                    if (upstreamBytesRead != -1L) break block21;
                    Relay.this.commit(Relay.this.getUpstreamPos());
                    l = -1L;
                    Relay bufferPos22 = Relay.this;
                    relay2 = Relay.this;
                    bytesToRead2 = bufferPos22;
                }
                catch (Throwable throwable) {
                    relay4 = Relay.this;
                    relay5 = Relay.this;
                    Relay relay6 = relay4;
                    synchronized (relay6) {
                        boolean bl = false;
                        relay5.setUpstreamReader(null);
                        Relay $this$notifyAll$iv = relay5;
                        boolean $i$f$notifyAll = false;
                        Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        $this$notifyAll$iv.notifyAll();
                        Unit unit = Unit.INSTANCE;
                        throw throwable;
                    }
                }
                synchronized (bytesToRead2) {
                    boolean $i$a$-synchronized-Relay$RelaySource$read$32 = false;
                    relay2.setUpstreamReader(null);
                    Relay $this$notifyAll$iv = relay2;
                    boolean $i$f$notifyAll = false;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)$this$notifyAll$iv).notifyAll();
                    Unit $i$a$-synchronized-Relay$RelaySource$read$32 = Unit.INSTANCE;
                    return l;
                }
            }
            long bytesRead = Math.min(upstreamBytesRead, byteCount);
            Relay.this.getUpstreamBuffer().copyTo(sink, 0L, bytesRead);
            this.sourcePos += bytesRead;
            FileOperator fileOperator = this.fileOperator;
            Intrinsics.checkNotNull((Object)fileOperator);
            fileOperator.write(32L + Relay.this.getUpstreamPos(), Relay.this.getUpstreamBuffer().clone(), upstreamBytesRead);
            Relay bufferPos22 = Relay.this;
            Relay relay7 = Relay.this;
            Relay bytesToRead2 = bufferPos22;
            synchronized (bytesToRead2) {
                boolean bl = false;
                relay7.getBuffer().write(relay7.getUpstreamBuffer(), upstreamBytesRead);
                if (relay7.getBuffer().size() > relay7.getBufferMaxSize()) {
                    relay7.getBuffer().skip(relay7.getBuffer().size() - relay7.getBufferMaxSize());
                }
                relay7.setUpstreamPos(relay7.getUpstreamPos() + upstreamBytesRead);
                object = Unit.INSTANCE;
            }
            long bufferPos22 = bytesRead;
            bytesToRead2 = Relay.this;
            object = Relay.this;
            Relay relay8 = bytesToRead2;
            synchronized (relay8) {
                boolean bl = false;
                ((Relay)object).setUpstreamReader(null);
                Object $this$notifyAll$iv = object;
                boolean $i$f$notifyAll = false;
                Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                $this$notifyAll$iv.notifyAll();
                Unit unit = Unit.INSTANCE;
                return bufferPos22;
            }
        }

        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            block5: {
                if (this.fileOperator == null) {
                    return;
                }
                this.fileOperator = null;
                RandomAccessFile fileToClose = null;
                Relay relay2 = Relay.this;
                Relay relay3 = Relay.this;
                Relay relay4 = relay2;
                synchronized (relay4) {
                    boolean bl = false;
                    int n = relay3.getSourceCount();
                    relay3.setSourceCount(n + -1);
                    if (relay3.getSourceCount() == 0) {
                        fileToClose = relay3.getFile();
                        relay3.setFile(null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                RandomAccessFile randomAccessFile = fileToClose;
                if (randomAccessFile == null) break block5;
                Util.closeQuietly(randomAccessFile);
            }
        }
    }
}

