/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache2;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

public final class FileOperator {
    @NotNull
    private final FileChannel fileChannel;

    public FileOperator(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
        this.fileChannel = fileChannel;
    }

    public final void write(long pos, @NotNull Buffer source, long byteCount) throws IOException {
        long bytesWritten;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (byteCount < 0L || byteCount > source.size()) {
            throw new IndexOutOfBoundsException();
        }
        long mutablePos = pos;
        for (long mutableByteCount = byteCount; mutableByteCount > 0L; mutableByteCount -= bytesWritten) {
            bytesWritten = this.fileChannel.transferFrom((ReadableByteChannel)source, mutablePos, mutableByteCount);
            mutablePos += bytesWritten;
        }
    }

    public final void read(long pos, @NotNull Buffer sink, long byteCount) {
        long bytesRead;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (byteCount < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long mutablePos = pos;
        for (long mutableByteCount = byteCount; mutableByteCount > 0L; mutableByteCount -= bytesRead) {
            bytesRead = this.fileChannel.transferTo(mutablePos, mutableByteCount, (WritableByteChannel)sink);
            mutablePos += bytesRead;
        }
    }
}

