/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\nokhttp3/MultipartReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class MultipartReader
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final String boundary;
    @NotNull
    private final ByteString dashDashBoundary;
    @NotNull
    private final ByteString crlfDashDashBoundary;
    private int partCount;
    private boolean closed;
    private boolean noMoreParts;
    @Nullable
    private PartSource currentPart;
    @NotNull
    private static final Options afterBoundaryOptions;

    public MultipartReader(@NotNull BufferedSource source, @NotNull String boundary) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        this.source = source;
        this.boundary = boundary;
        this.dashDashBoundary = new Buffer().writeUtf8("--").writeUtf8(this.boundary).readByteString();
        this.crlfDashDashBoundary = new Buffer().writeUtf8("\r\n--").writeUtf8(this.boundary).readByteString();
    }

    @JvmName(name="boundary")
    @NotNull
    public final String boundary() {
        return this.boundary;
    }

    public MultipartReader(@NotNull ResponseBody response2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Object object = response2.contentType();
        if (object == null || (object = ((MediaType)object).parameter("boundary")) == null) {
            throw new ProtocolException("expected the Content-Type to have a boundary parameter");
        }
        this(response2.source(), (String)object);
    }

    @Nullable
    public final Part nextPart() throws IOException {
        PartSource partSource;
        if (!(!this.closed)) {
            boolean $i$a$-check-MultipartReader$nextPart$22 = false;
            String $i$a$-check-MultipartReader$nextPart$22 = "closed";
            throw new IllegalStateException($i$a$-check-MultipartReader$nextPart$22.toString());
        }
        if (this.noMoreParts) {
            return null;
        }
        if (this.partCount == 0 && this.source.rangeEquals(0L, this.dashDashBoundary)) {
            this.source.skip((long)this.dashDashBoundary.size());
        } else {
            long toSkip;
            while ((toSkip = this.currentPartBytesRemaining(8192L)) != 0L) {
                this.source.skip(toSkip);
            }
            this.source.skip((long)this.crlfDashDashBoundary.size());
        }
        boolean whitespace = false;
        block7: while (true) {
            switch (this.source.select(afterBoundaryOptions)) {
                case 0: {
                    int n = this.partCount;
                    this.partCount = n + 1;
                    break block7;
                }
                case 1: {
                    if (whitespace) {
                        throw new ProtocolException("unexpected characters after boundary");
                    }
                    if (this.partCount == 0) {
                        throw new ProtocolException("expected at least 1 part");
                    }
                    this.noMoreParts = true;
                    return null;
                }
                case 2: 
                case 3: {
                    whitespace = true;
                    continue block7;
                }
                case -1: {
                    throw new ProtocolException("unexpected characters after boundary");
                }
                default: {
                    continue block7;
                }
            }
            break;
        }
        Headers headers2 = new HeadersReader(this.source).readHeaders();
        this.currentPart = partSource = new PartSource();
        return new Part(headers2, Okio.buffer((Source)partSource));
    }

    private final long currentPartBytesRemaining(long maxResult) {
        this.source.require((long)this.crlfDashDashBoundary.size());
        long delimiterIndex = this.source.getBuffer().indexOf(this.crlfDashDashBoundary);
        return delimiterIndex == -1L ? Math.min(maxResult, this.source.getBuffer().size() - (long)this.crlfDashDashBoundary.size() + 1L) : Math.min(maxResult, delimiterIndex);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.currentPart = null;
        this.source.close();
    }

    static {
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.encodeUtf8("\r\n"), ByteString.Companion.encodeUtf8("--"), ByteString.Companion.encodeUtf8(" "), ByteString.Companion.encodeUtf8("\t")};
        afterBoundaryOptions = Options.Companion.of(byteStringArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Options getAfterBoundaryOptions() {
            return afterBoundaryOptions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Part
    implements Closeable {
        @NotNull
        private final Headers headers;
        @NotNull
        private final BufferedSource body;

        public Part(@NotNull Headers headers2, @NotNull BufferedSource body) {
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            this.headers = headers2;
            this.body = body;
        }

        @JvmName(name="headers")
        @NotNull
        public final Headers headers() {
            return this.headers;
        }

        @JvmName(name="body")
        @NotNull
        public final BufferedSource body() {
            return this.body;
        }

        @Override
        public void close() {
            this.body.close();
        }
    }

    @SourceDebugExtension(value={"SMAP\nMultipartReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultipartReader.kt\nokhttp3/MultipartReader$PartSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timeout.kt\nokio/Timeout\n*L\n1#1,210:1\n1#2:211\n268#3,26:212\n*S KotlinDebug\n*F\n+ 1 MultipartReader.kt\nokhttp3/MultipartReader$PartSource\n*L\n159#1:212,26\n*E\n"})
    private final class PartSource
    implements Source {
        @NotNull
        private final Timeout timeout = new Timeout();

        public void close() {
            if (Intrinsics.areEqual((Object)MultipartReader.this.currentPart, (Object)this)) {
                MultipartReader.this.currentPart = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long read(@NotNull Buffer sink, long byteCount) {
            void other$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-MultipartReader$PartSource$read$22 = false;
                String $i$a$-require-MultipartReader$PartSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-MultipartReader$PartSource$read$22.toString());
            }
            if (!Intrinsics.areEqual((Object)MultipartReader.this.currentPart, (Object)this)) {
                boolean $i$a$-check-MultipartReader$PartSource$read$32 = false;
                String $i$a$-check-MultipartReader$PartSource$read$32 = "closed";
                throw new IllegalStateException($i$a$-check-MultipartReader$PartSource$read$32.toString());
            }
            Timeout timeout2 = MultipartReader.this.source.timeout();
            Timeout $i$a$-check-MultipartReader$PartSource$read$32 = this.timeout;
            MultipartReader multipartReader = MultipartReader.this;
            boolean $i$f$intersectWith = false;
            long originalTimeout$iv = this_$iv.timeoutNanos();
            this_$iv.timeout(Timeout.Companion.minTimeout(other$iv.timeoutNanos(), this_$iv.timeoutNanos()), TimeUnit.NANOSECONDS);
            if (this_$iv.hasDeadline()) {
                long originalDeadline$iv = this_$iv.deadlineNanoTime();
                if (other$iv.hasDeadline()) {
                    this_$iv.deadlineNanoTime(Math.min(this_$iv.deadlineNanoTime(), other$iv.deadlineNanoTime()));
                }
                try {
                    boolean bl = false;
                    long limit = multipartReader.currentPartBytesRemaining(byteCount);
                    long l = limit == 0L ? -1L : multipartReader.source.read(sink, limit);
                    return l;
                }
                finally {
                    this_$iv.timeout(originalTimeout$iv, TimeUnit.NANOSECONDS);
                    if (other$iv.hasDeadline()) {
                        this_$iv.deadlineNanoTime(originalDeadline$iv);
                    }
                }
            }
            if (other$iv.hasDeadline()) {
                this_$iv.deadlineNanoTime(other$iv.deadlineNanoTime());
            }
            try {
                boolean bl = false;
                long limit = multipartReader.currentPartBytesRemaining(byteCount);
                long l = limit == 0L ? -1L : multipartReader.source.read(sink, limit);
                return l;
            }
            finally {
                this_$iv.timeout(originalTimeout$iv, TimeUnit.NANOSECONDS);
                if (other$iv.hasDeadline()) {
                    this_$iv.clearDeadline();
                }
            }
        }

        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }
    }
}

