/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class FormBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> encodedNames;
    @NotNull
    private final List<String> encodedValues;
    @NotNull
    private static final MediaType CONTENT_TYPE = MediaType.Companion.get("application/x-www-form-urlencoded");

    public FormBody(@NotNull List<String> encodedNames, @NotNull List<String> encodedValues) {
        Intrinsics.checkNotNullParameter(encodedNames, (String)"encodedNames");
        Intrinsics.checkNotNullParameter(encodedValues, (String)"encodedValues");
        this.encodedNames = Util.toImmutableList(encodedNames);
        this.encodedValues = Util.toImmutableList(encodedValues);
    }

    @JvmName(name="size")
    public final int size() {
        return this.encodedNames.size();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="size", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @NotNull
    public final String encodedName(int index) {
        return this.encodedNames.get(index);
    }

    @NotNull
    public final String name(int index) {
        return HttpUrl.Companion.percentDecode$okhttp$default(HttpUrl.Companion, this.encodedName(index), 0, 0, true, 3, null);
    }

    @NotNull
    public final String encodedValue(int index) {
        return this.encodedValues.get(index);
    }

    @NotNull
    public final String value(int index) {
        return HttpUrl.Companion.percentDecode$okhttp$default(HttpUrl.Companion, this.encodedValue(index), 0, 0, true, 3, null);
    }

    @Override
    @NotNull
    public MediaType contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public long contentLength() {
        return this.writeOrCountBytes(null, true);
    }

    @Override
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.writeOrCountBytes(sink, false);
    }

    private final long writeOrCountBytes(BufferedSink sink, boolean countBytes) {
        Buffer buffer;
        long byteCount = 0L;
        if (countBytes) {
            buffer = new Buffer();
        } else {
            BufferedSink bufferedSink = sink;
            Intrinsics.checkNotNull((Object)bufferedSink);
            buffer = bufferedSink.getBuffer();
        }
        Buffer buffer2 = buffer;
        int n = this.encodedNames.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 > 0) {
                buffer2.writeByte(38);
            }
            buffer2.writeUtf8(this.encodedNames.get(i2));
            buffer2.writeByte(61);
            buffer2.writeUtf8(this.encodedValues.get(i2));
        }
        if (countBytes) {
            byteCount = buffer2.size();
            buffer2.clear();
        }
        return byteCount;
    }

    public static final class Builder {
        @Nullable
        private final Charset charset;
        @NotNull
        private final List<String> names;
        @NotNull
        private final List<String> values;

        @JvmOverloads
        public Builder(@Nullable Charset charset) {
            this.charset = charset;
            this.names = new ArrayList();
            this.values = new ArrayList();
        }

        public /* synthetic */ Builder(Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                charset = null;
            }
            this(charset);
        }

        @NotNull
        public final Builder add(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$add_u24lambda_u240 = builder = this;
            boolean bl = false;
            ((Collection)$this$add_u24lambda_u240.names).add(HttpUrl.Companion.canonicalize$okhttp$default(HttpUrl.Companion, name2, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, false, $this$add_u24lambda_u240.charset, 91, null));
            ((Collection)$this$add_u24lambda_u240.values).add(HttpUrl.Companion.canonicalize$okhttp$default(HttpUrl.Companion, value2, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", false, false, true, false, $this$add_u24lambda_u240.charset, 91, null));
            return builder;
        }

        @NotNull
        public final Builder addEncoded(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addEncoded_u24lambda_u241 = builder = this;
            boolean bl = false;
            ((Collection)$this$addEncoded_u24lambda_u241.names).add(HttpUrl.Companion.canonicalize$okhttp$default(HttpUrl.Companion, name2, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, false, $this$addEncoded_u24lambda_u241.charset, 83, null));
            ((Collection)$this$addEncoded_u24lambda_u241.values).add(HttpUrl.Companion.canonicalize$okhttp$default(HttpUrl.Companion, value2, 0, 0, " \"':;<=>@[]^`{}|/\\?#&!$(),~", true, false, true, false, $this$addEncoded_u24lambda_u241.charset, 83, null));
            return builder;
        }

        @NotNull
        public final FormBody build() {
            return new FormBody(this.names, this.values);
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

